/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport.access;

import com.rapidminer.gui.tools.SimpleFileFilter;
import com.rapidminer.gui.tools.dialogs.SQLQueryBuilder;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DataImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.FileSelectionWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.RepositoryLocationSelectionWizardStep;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.io.DatabaseDataReader;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.AccessConnectionEntry;
import java.io.File;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;

public class AccessImportWizard
extends DataImportWizard {
    private static final long serialVersionUID = -4308448171060612833L;
    private final AccessConnectionEntry connectionEntry = new AccessConnectionEntry();
    private DatabaseDataReader reader = null;

    public AccessImportWizard(String i18nKey, Object ... i18nArgs) throws SQLException {
        this(i18nKey, null, null, i18nArgs);
    }

    public AccessImportWizard(String i18nKey, File preselectedFile, RepositoryLocation preselectedLocation, Object ... i18nArgs) throws SQLException {
        super(i18nKey, i18nArgs);
        this.connectionEntry.setFile(preselectedFile);
        try {
            this.reader = OperatorService.createOperator(DatabaseDataReader.class);
        }
        catch (OperatorCreationException e) {
            // empty catch block
        }
        if (preselectedFile == null) {
            this.addStep(new FileSelectionWizardStep(this, new FileFilter[]{new SimpleFileFilter("Access File (.mdb)", ".mdb")}){

                @Override
                protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                    AccessImportWizard.this.connectionEntry.setFile(this.getSelectedFile());
                    return true;
                }
            });
        }
        this.addStep(new WizardStep("database_query"){
            private final SQLQueryBuilder dialog;
            {
                this.dialog = new SQLQueryBuilder(null);
                this.dialog.addChangeListener(AccessImportWizard.this);
            }

            @Override
            protected boolean canGoBack() {
                return true;
            }

            @Override
            protected boolean canProceed() {
                return this.dialog.getQuery().length() > 0;
            }

            @Override
            protected JComponent getComponent() {
                return this.dialog.makeQueryBuilderPanel();
            }

            @Override
            protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
                this.dialog.setConnectionEntry(AccessImportWizard.this.connectionEntry);
                return true;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                AccessImportWizard.this.reader.setParameter("define_connection", DatabaseHandler.CONNECTION_MODES[1]);
                AccessImportWizard.this.reader.setParameter("database_system", AccessImportWizard.this.connectionEntry.getProperties().getName());
                AccessImportWizard.this.reader.setParameter("database_url", AccessImportWizard.this.connectionEntry.getURL());
                AccessImportWizard.this.reader.setParameter("username", AccessImportWizard.this.connectionEntry.getUser());
                AccessImportWizard.this.reader.setParameter("password", new String(AccessImportWizard.this.connectionEntry.getPassword()));
                AccessImportWizard.this.reader.setParameter("define_query", DatabaseHandler.QUERY_MODES[0]);
                AccessImportWizard.this.reader.setParameter("query", this.dialog.getQuery());
                return true;
            }
        });
        this.addStep(new RepositoryLocationSelectionWizardStep(this, preselectedLocation != null ? preselectedLocation.getAbsoluteLocation() : null){

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                return AccessImportWizard.this.transferData(AccessImportWizard.this.reader, this.getRepositoryLocation());
            }
        });
        this.layoutDefault();
    }
}

