/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.MetaDataDeclarationEditor;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractDataReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class MetaDataDeclerationWizardStep
extends WizardStep {
    protected MetaDataDeclarationEditor editor = null;
    protected AbstractDataReader reader;
    protected final JCheckBox tolerateErrorCheckBox = new JCheckBox("Read non matching values as missings.", true);
    private JButton abortValueTypeValidationButton;
    private JButton validateValueTypesButton;
    protected JPanel validationButtonsPanel;
    private JButton abortShowErrorRowsButton;
    private JButton showErrorRowsButton;
    protected JPanel errorPreviewButtonsPanel;
    private JButton abortGuessingButton;
    private JButton guessValueTypesButton;
    protected JPanel guessingButtonsPanel;

    public MetaDataDeclerationWizardStep(String key, AbstractDataReader reader) {
        super(key);
        this.tolerateErrorCheckBox.setToolTipText("Values which does not match to the specified value typed are considered as missings. A binomial attribute is changed to a nominal, if more than two different values are read.");
        this.tolerateErrorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataDeclerationWizardStep.this.reader.setErrorTolerant(MetaDataDeclerationWizardStep.this.tolerateErrorCheckBox.isSelected());
            }
        });
        this.abortValueTypeValidationButton = new JButton(new ResourceAction("wizard.abort_validate_value_types", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataDeclerationWizardStep.this.reader.stopReading();
            }
        });
        this.validateValueTypesButton = new JButton(new ResourceAction("wizard.validate_value_types", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new ProgressThread("validate_value_types"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<Object[]> previewAsList;
                        MetaDataDeclerationWizardStep.this.abortValueTypeValidationButton.setEnabled(true);
                        MetaDataDeclerationWizardStep.this.validateValueTypesButton.setEnabled(false);
                        MetaDataDeclerationWizardStep.this.reader.setDetectErrorsInPreview(true);
                        try {
                            MetaDataDeclerationWizardStep.this.reader.stopReading();
                            AbstractDataReader abstractDataReader = MetaDataDeclerationWizardStep.this.reader;
                            synchronized (abstractDataReader) {
                                previewAsList = MetaDataDeclerationWizardStep.this.reader.getPreviewAsList(this.getProgressListener(), false);
                            }
                        }
                        catch (OperatorException e1) {
                            SwingTools.showVerySimpleErrorMessage(e1.getMessage(), e1);
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MetaDataDeclerationWizardStep.this.setData(previewAsList);
                                MetaDataDeclerationWizardStep.this.reader.setDetectErrorsInPreview(false);
                                MetaDataDeclerationWizardStep.this.validateValueTypesButton.setEnabled(true);
                                MetaDataDeclerationWizardStep.this.abortValueTypeValidationButton.setEnabled(false);
                            }
                        });
                    }
                }.start();
            }
        });
        this.validationButtonsPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        this.validationButtonsPanel.add((Component)this.validateValueTypesButton, 0);
        this.validationButtonsPanel.add((Component)this.abortValueTypeValidationButton, 1);
        this.abortValueTypeValidationButton.setEnabled(false);
        this.abortShowErrorRowsButton = new JButton(new ResourceAction("wizard.abort_show_error_rows", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataDeclerationWizardStep.this.reader.stopReading();
            }
        });
        this.showErrorRowsButton = new JButton(new ResourceAction("wizard.show_error_rows", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new ProgressThread("show_error_rows"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<Object[]> previewAsList;
                        MetaDataDeclerationWizardStep.this.abortShowErrorRowsButton.setEnabled(true);
                        MetaDataDeclerationWizardStep.this.showErrorRowsButton.setEnabled(false);
                        try {
                            MetaDataDeclerationWizardStep.this.reader.stopReading();
                            AbstractDataReader abstractDataReader = MetaDataDeclerationWizardStep.this.reader;
                            synchronized (abstractDataReader) {
                                previewAsList = MetaDataDeclerationWizardStep.this.reader.getErrorPreviewAsList(this.getProgressListener());
                            }
                        }
                        catch (OperatorException e1) {
                            SwingTools.showVerySimpleErrorMessage(e1.getMessage(), e1);
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MetaDataDeclerationWizardStep.this.setData(previewAsList);
                                MetaDataDeclerationWizardStep.this.showErrorRowsButton.setEnabled(true);
                                MetaDataDeclerationWizardStep.this.abortShowErrorRowsButton.setEnabled(false);
                            }
                        });
                    }
                }.start();
            }
        });
        this.errorPreviewButtonsPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        this.errorPreviewButtonsPanel.add((Component)this.showErrorRowsButton, 0);
        this.errorPreviewButtonsPanel.add((Component)this.abortShowErrorRowsButton, 1);
        this.abortShowErrorRowsButton.setEnabled(false);
        this.abortGuessingButton = new JButton(new ResourceAction("wizard.abort_guess_value_types", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataDeclerationWizardStep.this.reader.stopReading();
            }
        });
        this.guessValueTypesButton = new JButton(new ResourceAction("wizard.guess_value_types", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new ProgressThread("guessing_value_types"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<Object[]> previewAsList;
                        try {
                            MetaDataDeclerationWizardStep.this.abortGuessingButton.setEnabled(true);
                            MetaDataDeclerationWizardStep.this.guessValueTypesButton.setEnabled(false);
                            MetaDataDeclerationWizardStep.this.reader.stopReading();
                            AbstractDataReader abstractDataReader = MetaDataDeclerationWizardStep.this.reader;
                            synchronized (abstractDataReader) {
                                MetaDataDeclerationWizardStep.this.reader.guessValueTypes(this.getProgressListener());
                                previewAsList = MetaDataDeclerationWizardStep.this.reader.getPreviewAsList(this.getProgressListener(), true, false, 300);
                            }
                        }
                        catch (OperatorException e1) {
                            SwingTools.showVerySimpleErrorMessage(e1.getMessage(), e1);
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MetaDataDeclerationWizardStep.this.setData(previewAsList);
                                MetaDataDeclerationWizardStep.this.guessValueTypesButton.setEnabled(true);
                                MetaDataDeclerationWizardStep.this.abortGuessingButton.setEnabled(false);
                            }
                        });
                    }
                }.start();
            }
        });
        this.guessingButtonsPanel = new JPanel(ButtonDialog.createGridLayout(1, 2));
        this.guessingButtonsPanel.add((Component)this.guessValueTypesButton, 0);
        this.guessingButtonsPanel.add((Component)this.abortGuessingButton, 1);
        this.abortGuessingButton.setEnabled(false);
        this.editor = new MetaDataDeclarationEditor(reader, true);
        this.reader = reader;
    }

    protected void setData(List<Object[]> data) {
        this.editor.setData(data);
    }

    @Override
    protected JComponent getComponent() {
        JPanel errorTolerancePanel = new JPanel(ButtonDialog.createGridLayout(2, 2));
        errorTolerancePanel.setBorder(ButtonDialog.createTitledBorder("Error Handling"));
        errorTolerancePanel.add((Component)this.tolerateErrorCheckBox, 0);
        errorTolerancePanel.add((Component)this.validationButtonsPanel, 1);
        errorTolerancePanel.add((Component)new JPanel(), 2);
        errorTolerancePanel.add((Component)this.errorPreviewButtonsPanel, 3);
        this.editor.setBorder(ButtonDialog.createTitledBorder("Data Preview"));
        JPanel panel = new JPanel(new BorderLayout(0, 6));
        panel.add((Component)errorTolerancePanel, "North");
        panel.add((Component)this.editor, "Center");
        return panel;
    }

    @Override
    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        this.setData(new LinkedList<Object[]>());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ProgressThread("guessing_value_types"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            List<Object[]> previewAsList;
                            MetaDataDeclerationWizardStep.this.reader.stopReading();
                            AbstractDataReader abstractDataReader = MetaDataDeclerationWizardStep.this.reader;
                            synchronized (abstractDataReader) {
                                previewAsList = MetaDataDeclerationWizardStep.this.reader.getPreviewAsList(this.getProgressListener(), true);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MetaDataDeclerationWizardStep.this.setData(previewAsList);
                                    MetaDataDeclerationWizardStep.this.doAfterEnteringAction();
                                }
                            });
                        }
                        catch (OperatorException e1) {
                            SwingTools.showVerySimpleErrorMessage(e1.getMessage(), e1);
                            return;
                        }
                    }
                }.start();
            }
        });
        return true;
    }

    protected void doAfterEnteringAction() {
    }

    @Override
    protected boolean canGoBack() {
        return true;
    }

    @Override
    protected boolean canProceed() {
        return true;
    }
}

