/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.operator.io.AbstractDataReader;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class MetaDataDeclarationEditor
extends JPanel {
    private static final long serialVersionUID = -520323914589387512L;
    private MetaDataTable metadataTable;
    private PreviewTable previewTable;
    TableColumnModelListener metadataColumnListener;
    private AbstractDataReader reader = null;
    private UpdateQueue updateQueue = new UpdateQueue("ImportWizardDataRefresher");
    private static final Color BLUE = new Color(52, 86, 164);
    private static final Color YELLOW = new Color(245, 223, 171);
    private final Color backGroundGray = this.getBackground();
    private static final int ROLE_ROW = 3;
    private static final int IS_SELECTED_ROW = 2;
    private static final int VALUE_TYPE_ROW = 1;
    private static final int ATTRIBUTE_NAME_ROW = 0;

    public MetaDataDeclarationEditor(AbstractDataReader reader, final boolean showMetaDataEditor) {
        super(new BorderLayout());
        this.reader = reader;
        this.metadataTable = new MetaDataTable();
        this.previewTable = new PreviewTable();
        ExtendedJScrollPane metadataPane = new ExtendedJScrollPane(this.metadataTable);
        ExtendedJScrollPane dataPane = new ExtendedJScrollPane(this.previewTable){
            private static final long serialVersionUID = 1L;

            @Override
            public void setColumnHeaderView(Component view) {
                if (!showMetaDataEditor) {
                    super.setColumnHeaderView(view);
                }
            }
        };
        this.metadataColumnListener = new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                assert (MetaDataDeclarationEditor.this.previewTable.getColumnCount() == MetaDataDeclarationEditor.this.metadataTable.getColumnCount());
                for (int i = 0; i < MetaDataDeclarationEditor.this.previewTable.getColumnCount(); ++i) {
                    int columnwidth = MetaDataDeclarationEditor.this.metadataTable.getColumnModel().getColumn(i).getWidth();
                    int oldwidth = MetaDataDeclarationEditor.this.previewTable.getColumnModel().getColumn(i).getPreferredWidth();
                    if (oldwidth == columnwidth) continue;
                    MetaDataDeclarationEditor.this.previewTable.getColumnModel().getColumn(i).setPreferredWidth(columnwidth);
                }
                MetaDataDeclarationEditor.this.previewTable.doLayout();
                MetaDataDeclarationEditor.this.previewTable.repaint();
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        };
        if (showMetaDataEditor) {
            metadataPane.setHorizontalScrollBarPolicy(31);
            metadataPane.setVerticalScrollBarPolicy(22);
            JScrollBar bar = metadataPane.getVerticalScrollBar();
            JScrollBar dummyBar = new JScrollBar(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    g.setColor(MetaDataDeclarationEditor.this.backGroundGray);
                    g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                }
            };
            dummyBar.setPreferredSize(bar.getPreferredSize());
            metadataPane.setVerticalScrollBar(dummyBar);
            final JScrollBar bar1 = metadataPane.getHorizontalScrollBar();
            JScrollBar bar2 = dataPane.getHorizontalScrollBar();
            bar2.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    bar1.setValue(e.getValue());
                }
            });
            this.metadataTable.getColumnModel().addColumnModelListener(this.metadataColumnListener);
            metadataPane.setPreferredSize(new Dimension(400, 103));
            this.add((Component)metadataPane, "North");
        }
        this.add((Component)dataPane, "Center");
        this.doLayout();
        this.updateQueue.start();
    }

    public void setData(List<Object[]> data) {
        this.previewTable.setData(data);
        this.metadataTable.updateTableStructure();
    }

    protected void finalize() throws Throwable {
        this.updateQueue.shutdown();
        super.finalize();
    }

    private class PreviewModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8096935282615030186L;
        private ArrayList<Object[]> data = null;

        private PreviewModel() {
        }

        private void setData(List<Object[]> data) {
            this.data = new ArrayList<Object[]>(data);
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return MetaDataDeclarationEditor.this.reader.getColumnCount() + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Row No.";
            }
            return MetaDataDeclarationEditor.this.reader.getAttributeColumn(columnIndex - 1).getName();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object[] values = this.data.get(row);
            if (column == 0) {
                return values[column].toString();
            }
            if (column >= values.length) {
                return "";
            }
            int attributeType = MetaDataDeclarationEditor.this.reader.getAttributeColumn(column - 1).getValueType();
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeType, 9) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeType, 9) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeType, 11)) {
                try {
                    return Tools.formatDateTime((Date)values[column]);
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            return values[column].toString();
        }
    }

    private class PreviewTable
    extends ExtendedJTable {
        private static final long serialVersionUID = 1L;
        private PreviewModel dataModel;

        private PreviewTable() {
            super(null, false, false, false, false, false);
            this.dataModel = new PreviewModel();
            this.setModel(this.dataModel);
            this.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                    if (col == 0) {
                        if (MetaDataDeclarationEditor.this.reader.hasParseErrorInRow(Integer.parseInt((String)PreviewTable.this.dataModel.getValueAt(row, 0)) - 1)) {
                            comp.setForeground(BLUE);
                            comp.setBackground(YELLOW);
                        } else {
                            comp.setForeground(Color.BLACK);
                            comp.setBackground(MetaDataDeclarationEditor.this.backGroundGray);
                        }
                        return comp;
                    }
                    if (MetaDataDeclarationEditor.this.reader.getAttributeColumn(--col).isActivated()) {
                        if (MetaDataDeclarationEditor.this.reader.hasParseError(col, Integer.parseInt((String)PreviewTable.this.dataModel.getValueAt(row, 0)) - 1)) {
                            comp.setForeground(BLUE);
                            comp.setBackground(YELLOW);
                        } else {
                            comp.setForeground(Color.BLACK);
                            if (row % 2 == 0) {
                                comp.setBackground(Color.WHITE);
                            } else if (MetaDataDeclarationEditor.this.reader.getAttributeColumn(col).getRole().equals("regular")) {
                                comp.setBackground(SwingTools.LIGHTEST_BLUE);
                            } else {
                                comp.setBackground(SwingTools.LIGHTEST_YELLOW);
                            }
                        }
                    } else {
                        comp.setForeground(Color.LIGHT_GRAY);
                        if (row % 2 == 0) {
                            comp.setBackground(Color.WHITE);
                        } else {
                            comp.setBackground(SwingTools.LIGHTEST_BLUE);
                        }
                    }
                    return comp;
                }
            });
            this.setColumnSelectionAllowed(true);
            this.setRowSelectionAllowed(true);
            this.setCellSelectionEnabled(false);
        }

        public void setData(List<Object[]> data) {
            this.dataModel.setData(data);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            TableCellEditor cellEditor = super.getCellEditor(row, column);
            return cellEditor;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public JPopupMenu createPopupMenu() {
            return new JPopupMenu();
        }
    }

    private class RoleSelectionCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 6077812831224991517L;

        public RoleSelectionCellEditor() {
            super(new JComboBox<Object>(AbstractDataReader.ROLE_NAMES.toArray()));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (!MetaDataDeclarationEditor.this.reader.getAttributeColumn(column - 1).isActivated()) {
                comp.setForeground(Color.LIGHT_GRAY);
            } else {
                comp.setForeground(Color.BLACK);
            }
            return comp;
        }
    }

    private class ColumnSelectionCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;

        private ColumnSelectionCellEditor() {
            super(new JCheckBox());
            ((JCheckBox)this.getComponent()).setSelected(true);
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int row, int column) {
            ((JCheckBox)this.getComponent()).setSelected((Boolean)MetaDataDeclarationEditor.this.metadataTable.getValueAt(row, column));
            return this.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }
    }

    private class ValueTypeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 7954919612214223430L;

        public ValueTypeCellEditor() {
            super(new JComboBox());
            DefaultComboBoxModel model = new DefaultComboBoxModel(){
                private static final long serialVersionUID = 914764579359633239L;
                private String[] valueTypes;
                {
                    int[] types = new int[]{6, 1, 3, 4, 9, 10, 11};
                    this.valueTypes = new String[types.length];
                    for (int i = 0; i < types.length; ++i) {
                        this.valueTypes[i] = Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(types[i]);
                    }
                }

                @Override
                public Object getElementAt(int index) {
                    return this.valueTypes[index];
                }

                @Override
                public int getSize() {
                    return this.valueTypes.length;
                }
            };
            ((JComboBox)super.getComponent()).setEnabled(true);
            ((JComboBox)super.getComponent()).setModel(model);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (!MetaDataDeclarationEditor.this.reader.getAttributeColumn(column - 1).isActivated()) {
                comp.setForeground(Color.LIGHT_GRAY);
            } else if (MetaDataDeclarationEditor.this.reader.hasParseErrorInColumn(column - 1)) {
                comp.setForeground(BLUE);
            } else {
                comp.setForeground(Color.BLACK);
            }
            return comp;
        }
    }

    private class MetaDataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8096935282615030186L;

        private MetaDataModel() {
        }

        @Override
        public int getColumnCount() {
            return MetaDataDeclarationEditor.this.reader.getColumnCount() + 1;
        }

        @Override
        public int getRowCount() {
            return Math.max(Math.max(1, 2), 3) + 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (rowIndex == 2) {
                    for (AbstractDataReader.AttributeColumn col : MetaDataDeclarationEditor.this.reader.getAllAttributeColumns()) {
                        if (!col.isActivated()) continue;
                        return true;
                    }
                    return false;
                }
                return "";
            }
            --columnIndex;
            if (rowIndex == 0) {
                return MetaDataDeclarationEditor.this.reader.getAttributeColumn(columnIndex).getName();
            }
            if (rowIndex == 1) {
                return Ontology.VALUE_TYPE_NAMES[MetaDataDeclarationEditor.this.reader.getAttributeColumn(columnIndex).getValueType()];
            }
            if (rowIndex == 2) {
                return MetaDataDeclarationEditor.this.reader.getAttributeColumn(columnIndex).isActivated();
            }
            if (rowIndex == 3) {
                return MetaDataDeclarationEditor.this.reader.getAttributeColumn(columnIndex).getRole();
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Row No.";
            }
            return Tools.getExcelColumnName(--columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 0) {
                if (row == 2) {
                    for (AbstractDataReader.AttributeColumn col : MetaDataDeclarationEditor.this.reader.getAllAttributeColumns()) {
                        col.activateColumn((Boolean)value);
                    }
                    MetaDataDeclarationEditor.this.repaint();
                }
                return;
            }
            --column;
            if (row == 0) {
                MetaDataDeclarationEditor.this.reader.setAttributeNamesDefinedByUser(true);
                MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).setName((String)value);
            }
            if (row == 1 && MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).getValueType() != Ontology.ATTRIBUTE_VALUE_TYPE.mapName(value.toString())) {
                MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).setValueType(Ontology.ATTRIBUTE_VALUE_TYPE.mapName(value.toString()));
            }
            if (row == 2) {
                MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).activateColumn((Boolean)value);
            }
            if (row == 3) {
                String role = (String)value;
                if (role.equals("regular")) {
                    MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).setRole(role);
                } else {
                    for (AbstractDataReader.AttributeColumn attColumn : MetaDataDeclarationEditor.this.reader.getAllAttributeColumns()) {
                        if (!attColumn.getRole().equals(role)) continue;
                        attColumn.setRole("regular");
                    }
                    MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).setRole(role);
                    this.fireTableDataChanged();
                }
            }
            MetaDataDeclarationEditor.this.repaint();
        }
    }

    private class MetaDataTable
    extends ExtendedJTable
    implements TableModelListener {
        private static final long serialVersionUID = 1L;
        private final MetaDataModel fixedHeaderModel;
        private ValueTypeCellEditor valueTypeCellEditor;
        private ValueTypeCellEditor valueTypeCellRenderer;
        private ColumnSelectionCellEditor checkBoxCellEditor;
        private ColumnSelectionCellEditor checkBoxCellRenderer;
        private RoleSelectionCellEditor roleCellEditor;
        private RoleSelectionCellEditor roleCellRenderer;
        private ColumnSelectionCellEditor globalCheckBoxCellEditor;

        private MetaDataTable() {
            super(null, false, false, false, false, false);
            this.fixedHeaderModel = new MetaDataModel();
            this.valueTypeCellEditor = null;
            this.valueTypeCellRenderer = null;
            this.checkBoxCellEditor = null;
            this.checkBoxCellRenderer = null;
            this.roleCellEditor = null;
            this.roleCellRenderer = null;
            this.globalCheckBoxCellEditor = new ColumnSelectionCellEditor();
            this.valueTypeCellEditor = new ValueTypeCellEditor();
            this.valueTypeCellRenderer = new ValueTypeCellEditor();
            this.checkBoxCellEditor = new ColumnSelectionCellEditor();
            this.checkBoxCellRenderer = new ColumnSelectionCellEditor();
            this.roleCellEditor = new RoleSelectionCellEditor();
            this.roleCellRenderer = new RoleSelectionCellEditor();
            this.setModel(this.fixedHeaderModel);
            this.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (column == 0) {
                        if (row == 2) {
                            return MetaDataTable.this.globalCheckBoxCellEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                        }
                        comp.setBackground(MetaDataDeclarationEditor.this.backGroundGray);
                        return comp;
                    }
                    --column;
                    if (row == 0) {
                        comp.setForeground(Color.BLACK);
                        if (!MetaDataDeclarationEditor.this.reader.hasParseErrorInColumn(column)) {
                            comp.setBackground(Color.WHITE);
                        } else {
                            comp.setBackground(YELLOW);
                        }
                        if (!MetaDataDeclarationEditor.this.reader.getAttributeColumn(column).isActivated()) {
                            comp.setForeground(Color.LIGHT_GRAY);
                        }
                        return comp;
                    }
                    if (row == 1) {
                        return MetaDataTable.this.valueTypeCellRenderer.getTableCellEditorComponent(table, value, isSelected, row, column + 1);
                    }
                    if (row == 2) {
                        return MetaDataTable.this.checkBoxCellRenderer.getTableCellEditorComponent(table, value, isSelected, row, column + 1);
                    }
                    if (row == 3) {
                        return MetaDataTable.this.roleCellRenderer.getTableCellEditorComponent(table, value, isSelected, row, column + 1);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column + 1);
                }
            });
            this.setColumnSelectionAllowed(false);
            this.setRowSelectionAllowed(false);
            this.setCellSelectionEnabled(false);
            this.getModel().fireTableStructureChanged();
        }

        @Override
        public MetaDataModel getModel() {
            return this.fixedHeaderModel;
        }

        public void updateTableStructure() {
            this.getModel().fireTableStructureChanged();
            this.packColumn();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MetaDataDeclarationEditor.this.metadataColumnListener.columnMarginChanged(null);
                }
            });
        }

        @Override
        public JPopupMenu createPopupMenu() {
            JPopupMenu popUp = super.createPopupMenu();
            return popUp;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                if (row == 2) {
                    return this.globalCheckBoxCellEditor;
                }
                return super.getCellEditor();
            }
            --column;
            if (row == 1) {
                return this.valueTypeCellEditor;
            }
            if (row == 2) {
                return this.checkBoxCellEditor;
            }
            if (row == 3) {
                return this.roleCellEditor;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return row == 2;
            }
            return row <= Math.max(Math.max(Math.max(0, 1), 2), 3);
        }
    }
}

