/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.DatabaseConnectionDialog;
import com.rapidminer.gui.tools.dialogs.SQLQueryBuilder;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DataImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.RepositoryLocationSelectionWizardStep;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.io.DatabaseDataReader;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import com.rapidminer.tools.jdbc.connection.FieldConnectionEntry;
import java.sql.SQLException;
import javax.swing.JComponent;

public class DatabaseImportWizard
extends DataImportWizard {
    private static final long serialVersionUID = -4308448171060612833L;
    private DatabaseDataReader reader = null;
    private FieldConnectionEntry connectionEntry = null;

    public DatabaseImportWizard(String i18nKey, Object ... i18nArgs) throws SQLException {
        super(i18nKey, i18nArgs);
        try {
            this.reader = OperatorService.createOperator(DatabaseDataReader.class);
        }
        catch (OperatorCreationException e) {
            // empty catch block
        }
        final SQLQueryBuilder sqlQueryBuilder = new SQLQueryBuilder(null);
        this.addStep(new WizardStep("database_connection"){
            private final DatabaseConnectionDialog dialog;
            {
                super(x0);
                this.dialog = new DatabaseConnectionDialog("manage_db_connections", new Object[0]);
                this.dialog.addChangeListener(DatabaseImportWizard.this);
            }

            @Override
            protected boolean canGoBack() {
                return false;
            }

            @Override
            protected boolean canProceed() {
                FieldConnectionEntry entry = this.dialog.getConnectionEntry(false);
                return entry != null;
            }

            @Override
            protected JComponent getComponent() {
                return this.dialog.makeConnectionManagementPanel();
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                FieldConnectionEntry entry = this.dialog.getConnectionEntry(false);
                if (entry == null) {
                    return false;
                }
                try {
                    if (!DatabaseConnectionService.testConnection(entry)) {
                        throw new SQLException();
                    }
                }
                catch (SQLException e) {
                    SwingTools.showVerySimpleErrorMessage("db_connection_failed", entry.getDatabase(), entry.getHost(), entry.getPort(), entry.getURL());
                    return false;
                }
                DatabaseImportWizard.this.reader.setParameter("define_connection", DatabaseHandler.CONNECTION_MODES[1]);
                DatabaseImportWizard.this.reader.setParameter("database_system", entry.getProperties().getName());
                DatabaseImportWizard.this.reader.setParameter("database_url", entry.getURL());
                DatabaseImportWizard.this.reader.setParameter("username", entry.getUser());
                DatabaseImportWizard.this.reader.setParameter("password", new String(entry.getPassword()));
                DatabaseImportWizard.this.connectionEntry = entry;
                sqlQueryBuilder.setConnectionEntry(DatabaseImportWizard.this.connectionEntry);
                return true;
            }
        });
        this.addStep(new WizardStep("database_query"){
            {
                super(x0);
                sqlQueryBuilder.addChangeListener(DatabaseImportWizard.this);
            }

            @Override
            protected boolean canGoBack() {
                return true;
            }

            @Override
            protected boolean canProceed() {
                return sqlQueryBuilder.getQuery().length() > 0;
            }

            @Override
            protected JComponent getComponent() {
                return sqlQueryBuilder.makeQueryBuilderPanel();
            }

            @Override
            protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
                sqlQueryBuilder.setConnectionEntry(DatabaseImportWizard.this.connectionEntry);
                return true;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                DatabaseImportWizard.this.reader.setParameter("define_query", DatabaseHandler.QUERY_MODES[0]);
                DatabaseImportWizard.this.reader.setParameter("query", sqlQueryBuilder.getQuery());
                return true;
            }
        });
        this.addStep(new RepositoryLocationSelectionWizardStep(this, null){

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                return DatabaseImportWizard.this.transferData(DatabaseImportWizard.this.reader, this.getRepositoryLocation());
            }
        });
        this.layoutDefault();
    }
}

