/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.access.AccessImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.CSVImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel.ExcelImportWizard;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.ProgressListener;
import java.awt.Frame;
import java.io.File;
import java.sql.SQLException;

public class DataImportWizard
extends AbstractWizard {
    private static final long serialVersionUID = 6361602131820283501L;

    public DataImportWizard(String key, Object ... arguments) {
        super((Frame)RapidMinerGUI.getMainFrame(), key, arguments);
    }

    protected boolean transferData(final AbstractExampleSource reader, final String repositoryLocationPath) {
        RepositoryLocation location;
        if (repositoryLocationPath == null) {
            return false;
        }
        try {
            location = new RepositoryLocation(repositoryLocationPath);
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("malformed_rep_location", (Throwable)e, repositoryLocationPath);
            return false;
        }
        ProgressThread t = new ProgressThread("import_data", true){

            @Override
            public void run() {
                ExampleSet exampleSet;
                ProgressListener l = this.getProgressListener();
                l.setTotal(100);
                l.setCompleted(10);
                try {
                    exampleSet = reader.createExampleSet();
                }
                catch (OperatorException e) {
                    SwingTools.showSimpleErrorMessage("could not read from access file", (Throwable)e, new Object[0]);
                    return;
                }
                l.setCompleted(55);
                try {
                    RepositoryManager.getInstance(null).store(exampleSet, location, null);
                    l.setCompleted(95);
                }
                catch (RepositoryException ex) {
                    SwingTools.showSimpleErrorMessage("cannot_store_obj_at_location", (Throwable)ex, repositoryLocationPath);
                    return;
                }
                l.setCompleted(100);
            }
        };
        t.start();
        return true;
    }

    public static void importData(File file, RepositoryLocation location) {
        int dot = file.getName().lastIndexOf(46);
        if (dot != -1) {
            String extension = file.getName().substring(dot + 1);
            if ("csv".equals(extension)) {
                new CSVImportWizard("import_csv_file", file, location).setVisible(true);
            } else if ("xls".equals(extension)) {
                new ExcelImportWizard("import_excel_sheet", file, location, new Object[0]).setVisible(true);
            } else if ("mdb".equals(extension)) {
                try {
                    new AccessImportWizard("import_access_table", file, location, new Object[0]).setVisible(true);
                }
                catch (SQLException e) {
                    SwingTools.showSimpleErrorMessage("db_connection_failed_simple", (Throwable)e, e.getMessage());
                }
            } else {
                SwingTools.showVerySimpleErrorMessage("importwizard.filetype_not_supported", extension);
            }
        } else {
            SwingTools.showVerySimpleErrorMessage("importwizard.filetype_not_supported", file.getName());
        }
    }
}

