/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.tools.Ontology;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class DataEditor
extends ExtendedJTable {
    private static final long serialVersionUID = -520323914589387512L;
    private static final int[][] VALUE_TYPE_OPTIONS = new int[][]{new int[0], {1}, {2}, {2, 3}, {2, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {9}, {9, 10}, {9, 11}};
    private boolean showValueTypes = false;
    private boolean editValueTypes = false;
    private final DataModel model = new DataModel();
    private final DataEditorCellRenderer cellRenderer = new DataEditorCellRenderer();
    private ValueTypeCellEditor[] valueTypeCellEditors = null;

    public DataEditor() {
        super(null, false, false, false, false, false);
        this.setModel(this.model);
        this.setDefaultRenderer(String.class, this.cellRenderer);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
    }

    public DataEditor(boolean showValueTypes) {
        this();
        this.showValueTypes = showValueTypes;
    }

    public DataEditor(boolean showValueTypes, boolean editValueTypes) {
        this();
        this.showValueTypes = true;
        this.editValueTypes = editValueTypes;
    }

    public void setData(ExampleSetMetaData metaData, List<Object[]> data) {
        this.valueTypeCellEditors = new ValueTypeCellEditor[metaData.getAllAttributes().size()];
        int i = 0;
        for (AttributeMetaData amd : metaData.getAllAttributes()) {
            this.valueTypeCellEditors[i++] = new ValueTypeCellEditor(amd.getValueType());
        }
        this.model.setData(metaData, data);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (row == 0 && this.showValueTypes) {
            return this.valueTypeCellEditors[column];
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return row == 0 && this.editValueTypes;
    }

    private class DataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8096935282615030186L;
        private AttributeMetaData[] attributes = null;
        private List<Object[]> data = null;

        private DataModel() {
        }

        private void setData(ExampleSetMetaData metaData, List<Object[]> data) {
            this.attributes = new AttributeMetaData[metaData.getAllAttributes().size()];
            int i = 0;
            for (AttributeMetaData amd : metaData.getAllAttributes()) {
                this.attributes[i++] = amd;
            }
            this.data = data;
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.attributes != null ? this.attributes.length : 0;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.attributes[columnIndex].getName();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        private int getRowOffset() {
            int offset = 0;
            return offset += DataEditor.this.showValueTypes ? 1 : 0;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() + this.getRowOffset() : 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row == 0 && DataEditor.this.showValueTypes) {
                return Ontology.VALUE_TYPE_NAMES[this.attributes[column].getValueType()];
            }
            if (row >= this.getRowOffset()) {
                Object[] values = this.data.get(row - this.getRowOffset());
                if (column >= values.length) {
                    return "";
                }
                if (values[column] == null) {
                    return "";
                }
                return values[column].toString();
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row == 0 && DataEditor.this.editValueTypes) {
                this.attributes[column].setType(Ontology.ATTRIBUTE_VALUE_TYPE.mapName(value.toString()));
                DataEditor.this.repaint();
            }
        }
    }

    private class DataEditorCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -4373454555123741476L;

        private DataEditorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (row == 0 && DataEditor.this.showValueTypes) {
                return DataEditor.this.valueTypeCellEditors[column].getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class ValueTypeCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 7954919612214223430L;

        public ValueTypeCellEditor(final int valueType) {
            super(new JComboBox());
            DefaultComboBoxModel model = new DefaultComboBoxModel(){
                private static final long serialVersionUID = 914764579359633239L;
                private String[] valueTypes;
                {
                    this.valueTypes = new String[VALUE_TYPE_OPTIONS[valueType].length];
                    for (int i = 0; i < VALUE_TYPE_OPTIONS[valueType].length; ++i) {
                        this.valueTypes[i] = Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(VALUE_TYPE_OPTIONS[valueType][i]);
                    }
                }

                @Override
                public Object getElementAt(int index) {
                    return this.valueTypes[index];
                }

                @Override
                public int getSize() {
                    return this.valueTypes.length;
                }
            };
            ((JComboBox)super.getComponent()).setEnabled(DataEditor.this.editValueTypes);
            ((JComboBox)super.getComponent()).setModel(model);
        }
    }
}

