/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.FileSelectionWizardStep;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.RepositoryLocationSelectionWizardStep;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.Tools;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class BlobImportWizard
extends AbstractWizard {
    public static final Action IMPORT_BLOB_ACTION = new ResourceAction("import_blob", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            new BlobImportWizard(RapidMinerGUI.getMainFrame()).setVisible(true);
        }
    };
    private static final long serialVersionUID = 1L;
    private File file;

    public BlobImportWizard(Frame owner) {
        super((Frame)RapidMinerGUI.getMainFrame(), "import_blob", new Object[0]);
        this.addStep(new FileSelectionWizardStep(this, new FileFilter[0]){

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                BlobImportWizard.this.file = this.getSelectedFile();
                return true;
            }
        });
        this.addStep(new RepositoryLocationSelectionWizardStep(this, null){

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                try {
                    String mimeType;
                    BlobEntry blob;
                    RepositoryLocation repositoryLocation = new RepositoryLocation(this.getRepositoryLocation());
                    RepositoryLocation folderLocation = repositoryLocation.parent();
                    Entry entry = folderLocation.locateEntry();
                    if (entry != null && entry instanceof Folder) {
                        Folder parent = (Folder)entry;
                        parent.createBlobEntry(repositoryLocation.getName());
                        Entry newEntry = repositoryLocation.locateEntry();
                        if (newEntry == null) {
                            throw new RepositoryException("Creation of blob entry failed.");
                        }
                        blob = (BlobEntry)newEntry;
                        mimeType = "application/octet-stream";
                        String name = BlobImportWizard.this.file.getName().toLowerCase();
                        if (name.endsWith(".htm") || name.endsWith(".html")) {
                            mimeType = "text/html";
                        } else if (name.endsWith(".txt")) {
                            mimeType = "text/plain";
                        } else if (name.endsWith(".pdf")) {
                            mimeType = "application/pdf";
                        } else if (name.endsWith(".png")) {
                            mimeType = "image/png";
                        } else if (name.endsWith(".jpeg")) {
                            mimeType = "image/jpeg";
                        } else if (name.endsWith(".gif")) {
                            mimeType = "image/gif";
                        }
                    } else {
                        throw new RepositoryException("No such folder: '" + folderLocation + "'.");
                    }
                    Tools.copyStreamSynchronously(new FileInputStream(BlobImportWizard.this.file), blob.openOutputStream(mimeType), true);
                    return true;
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("import_blob_failed", (Throwable)e, e.getMessage());
                    return false;
                }
            }
        });
        this.layoutDefault();
    }
}

