/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards.dataimport;

import com.rapidminer.example.Attributes;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AttributeSelectionWizardStep
extends WizardStep {
    private static final String[] ROLE_NAMES = new String[Attributes.KNOWN_ATTRIBUTE_TYPES.length];
    private AttributeMetaData[] attributes;
    private RoleSelectionTable table;

    public AttributeSelectionWizardStep(String key) {
        super(key);
        for (int i = 0; i < ROLE_NAMES.length; ++i) {
            AttributeSelectionWizardStep.ROLE_NAMES[i] = Attributes.KNOWN_ATTRIBUTE_TYPES[i].equals("attribute") ? "regular" : Attributes.KNOWN_ATTRIBUTE_TYPES[i];
        }
        this.table = new RoleSelectionTable();
    }

    public void setMetaData(ExampleSetMetaData metaData) {
        this.table.setMetaData(metaData);
    }

    @Override
    protected JComponent getComponent() {
        ExtendedJScrollPane pane = new ExtendedJScrollPane(this.table);
        pane.setBorder(ButtonDialog.createBorder());
        return pane;
    }

    static /* synthetic */ AttributeMetaData[] access$002(AttributeSelectionWizardStep x0, AttributeMetaData[] x1) {
        x0.attributes = x1;
        return x1;
    }

    class RoleSelectionTable
    extends JTable {
        private static final long serialVersionUID = -4636146637929280203L;
        private LinkedList<RoleSelectionEditor> editors;

        public RoleSelectionTable() {
            super(new RoleSelectionTableModel());
            this.editors = new LinkedList();
            this.setRowHeight(28);
        }

        public void setMetaData(ExampleSetMetaData metaData) {
            ((RoleSelectionTableModel)this.getModel()).setMetaData(metaData);
            this.updateEditorsAndRenderers();
        }

        public void updateEditorsAndRenderers() {
            if (this.editors != null) {
                this.editors.clear();
                int numberOfRows = this.getModel().getRowCount();
                for (int i = 0; i < numberOfRows; ++i) {
                    JComboBox<String> comboBox = new JComboBox<String>(ROLE_NAMES);
                    comboBox.setEditable(true);
                    RoleSelectionEditor editor = new RoleSelectionEditor(comboBox);
                    this.editors.add(editor);
                }
            }
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 1: {
                    return this.editors.get(row);
                }
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return super.getCellRenderer(row, column);
            }
            return this.editors.get(row);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateEditorsAndRenderers();
            super.tableChanged(e);
        }

        class RoleSelectionEditor
        extends DefaultCellEditor
        implements TableCellRenderer {
            private static final long serialVersionUID = 6077812831224991517L;

            public RoleSelectionEditor(JComboBox comboBox) {
                super(comboBox);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return this.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        }
    }

    class RoleSelectionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8756273955084001031L;

        RoleSelectionTableModel() {
        }

        public void setMetaData(ExampleSetMetaData metaData) {
            AttributeSelectionWizardStep.access$002(AttributeSelectionWizardStep.this, new AttributeMetaData[metaData.getAllAttributes().size()]);
            int i = 0;
            for (AttributeMetaData amd : metaData.getAllAttributes()) {
                ((AttributeSelectionWizardStep)AttributeSelectionWizardStep.this).attributes[i++] = amd;
            }
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Role";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return AttributeSelectionWizardStep.this.attributes != null ? AttributeSelectionWizardStep.this.attributes.length : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AttributeSelectionWizardStep.this.attributes[rowIndex].getName();
                }
                case 1: {
                    return AttributeSelectionWizardStep.this.attributes[rowIndex].isSpecial() ? AttributeSelectionWizardStep.this.attributes[rowIndex].getRole() : "regular";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    String name = (String)value;
                    if (name == null || name.isEmpty()) break;
                    boolean existent = false;
                    for (int i = 0; i < AttributeSelectionWizardStep.this.attributes.length; ++i) {
                        if (i == rowIndex || !AttributeSelectionWizardStep.this.attributes[i].getName().equals(name)) continue;
                        existent = true;
                        break;
                    }
                    AttributeSelectionWizardStep.this.attributes[rowIndex].setName(name + (existent ? "_" + (rowIndex + 1) : ""));
                    break;
                }
                case 1: {
                    String role = (String)value;
                    if ("regular".equals(role)) {
                        AttributeSelectionWizardStep.this.attributes[rowIndex].setRegular();
                        break;
                    }
                    for (int i = 0; i < AttributeSelectionWizardStep.this.attributes.length; ++i) {
                        if (!AttributeSelectionWizardStep.this.attributes[i].isSpecial() || !AttributeSelectionWizardStep.this.attributes[i].getRole().equals(role)) continue;
                        AttributeSelectionWizardStep.this.attributes[i].setRegular();
                    }
                    AttributeSelectionWizardStep.this.attributes[rowIndex].setRole(role);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
    }
}

