/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards;

import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.tools.I18N;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class WizardStep {
    private static final long serialVersionUID = -2692323833542816565L;
    private LinkedList<ChangeListener> listeners = new LinkedList();
    private String i18nKey;

    public WizardStep(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    private String getKey() {
        return "gui.dialog.step." + this.i18nKey;
    }

    protected String getTitle() {
        return I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".title", new Object[0]);
    }

    protected String getInfoText() {
        return I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".message", new Object[0]);
    }

    protected abstract JComponent getComponent();

    protected Collection<AbstractButton> getButtons() {
        return Collections.emptyList();
    }

    public void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(e);
        }
    }

    protected void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    protected void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract boolean canProceed();

    protected abstract boolean canGoBack();

    protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
        return this.performEnteringAction();
    }

    protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
        return this.performLeavingAction();
    }

    @Deprecated
    protected boolean performEnteringAction() {
        return true;
    }

    @Deprecated
    protected boolean performLeavingAction() {
        return true;
    }
}

