/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs.wizards;

import com.rapidminer.gui.tools.dialogs.MultiPageDialog;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class AbstractWizard
extends MultiPageDialog {
    private static final long serialVersionUID = 7091671433172940496L;
    private ArrayList<WizardStep> wizardSteps = new ArrayList();
    private boolean showStepNumbersInTitle = true;
    private boolean showStepInfo = true;

    public AbstractWizard(Dialog owner, String key, Object ... arguments) {
        super(owner, key, false, arguments);
    }

    public AbstractWizard(Frame owner, String key, Object ... arguments) {
        super(owner, key, false, arguments);
    }

    public AbstractWizard(Dialog owner, String key, boolean modal, Object ... arguments) {
        super(owner, key, modal, arguments);
    }

    public AbstractWizard(Frame owner, String key, boolean modal, Object ... arguments) {
        super(owner, key, modal, arguments);
    }

    protected void layoutDefault(int size) {
        LinkedHashMap<String, Component> cards = new LinkedHashMap<String, Component>();
        for (WizardStep wizardStep : this.wizardSteps) {
            cards.put(wizardStep.getTitle(), wizardStep.getComponent());
        }
        this.layoutDefault(cards, size);
        this.updateTitle();
        this.updateInfoHeader();
    }

    protected void layoutDefault() {
        this.layoutDefault(1);
    }

    protected void addStep(WizardStep wizardStep) {
        wizardStep.addChangeListener(this);
        this.wizardSteps.add(wizardStep);
    }

    @Override
    protected boolean canProceed(int step) {
        return this.wizardSteps.get(step).canProceed();
    }

    @Override
    protected boolean canGoBack(int step) {
        return this.wizardSteps.get(step).canGoBack();
    }

    @Override
    protected String getNameForStep(int step) {
        return this.wizardSteps.get(step).getTitle();
    }

    @Override
    protected boolean isComplete() {
        return this.wizardSteps.get(this.wizardSteps.size() - 1).canProceed();
    }

    @Override
    protected boolean isLastStep(int step) {
        return step == this.wizardSteps.size() - 1;
    }

    @Override
    protected void previous() {
        if (!this.getCurrentWizardStep().performLeavingAction(WizardStepDirection.BACKWARD)) {
            return;
        }
        super.previous();
        this.updateTitle();
        this.updateInfoHeader();
        this.getCurrentWizardStep().performEnteringAction(WizardStepDirection.BACKWARD);
    }

    @Override
    protected void next() {
        if (!this.getCurrentWizardStep().performLeavingAction(WizardStepDirection.FORWARD)) {
            return;
        }
        super.next();
        this.updateTitle();
        this.updateInfoHeader();
        this.getCurrentWizardStep().performEnteringAction(WizardStepDirection.FORWARD);
    }

    @Override
    protected void finish() {
        if (!this.getCurrentWizardStep().performLeavingAction(WizardStepDirection.FINISH)) {
            return;
        }
        super.finish();
    }

    private WizardStep getCurrentWizardStep() {
        return this.wizardSteps.get(this.getCurrentStep());
    }

    protected void updateTitle() {
        if (this.showStepNumbersInTitle) {
            this.setTitle(this.getDialogTitle() + " - Step " + (this.getCurrentStep() + 1) + " of " + this.wizardSteps.size());
        }
    }

    protected void updateInfoHeader() {
        if (this.showStepInfo) {
            this.infoTextLabel.setText(this.getInfoText() + "<br/><b>Step " + (this.getCurrentStep() + 1) + ":</b> " + this.wizardSteps.get(this.getCurrentStep()).getInfoText());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.getCurrentWizardStep().performEnteringAction(WizardStepDirection.BEGINNING);
        super.setVisible(visible);
    }

    public static enum WizardStepDirection {
        BEGINNING,
        FORWARD,
        BACKWARD,
        FINISH;

    }
}

