/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class SetParameterDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1484984144870499737L;
    private final Operator operator;
    private final ParameterType type;
    private final PropertyValueCellEditor editor;
    private boolean canceled = false;

    public SetParameterDialog(Operator operator, ParameterType type) {
        super("set_parameter", type.getKey().replace('_', ' '));
        this.operator = operator;
        this.type = type;
        this.editor = PropertyPanel.instantiateValueCellEditor(type, operator);
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                SetParameterDialog.this.cancel();
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                if (!SetParameterDialog.this.canceled) {
                    SetParameterDialog.this.ok();
                } else {
                    SetParameterDialog.this.cancel();
                }
            }
        });
        JComponent editorComponent = (JComponent)this.editor.getTableCellEditorComponent(null, type.getDefaultValue(), false, 0, 1);
        editorComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SetParameterDialog.this.canceled = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JButton okButton = this.makeOkButton();
        this.layoutDefault(editorComponent, okButton, this.makeCancelButton());
        this.getRootPane().setDefaultButton(okButton);
    }

    @Override
    protected String getInfoText() {
        return this.type.getDescription();
    }

    @Override
    protected void ok() {
        Object value = this.editor.getCellEditorValue();
        if (value != null && ((String)value).length() != 0) {
            this.operator.setParameter(this.type.getKey(), (String)value);
            super.ok();
        }
    }
}

