/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SQLEditor;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.syntax.DefaultInputHandler;
import com.rapidminer.gui.tools.syntax.InputHandler;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SQLQueryBuilder
extends ButtonDialog {
    private static final long serialVersionUID = 1779762368364719191L;
    private final JList tableList = new JList();
    private final JList attributeList = new JList();
    private final JTextArea whereTextArea = new JTextArea(4, 15);
    private final SQLEditor sqlQueryTextArea = new SQLEditor();
    private final Map<String, List<ColumnIdentifier>> attributeNameMap;
    private DatabaseHandler databaseHandler;

    public SQLQueryBuilder(DatabaseHandler databaseHandler) {
        super("build_sql_query", true, new Object[0]);
        DefaultInputHandler inputHandler = new DefaultInputHandler(){

            @Override
            public void keyReleased(KeyEvent e) {
                SQLQueryBuilder.this.fireStateChanged();
                super.keyReleased(e);
            }
        };
        ((InputHandler)inputHandler).addDefaultKeyBindings();
        this.sqlQueryTextArea.setInputHandler(inputHandler);
        this.attributeNameMap = new LinkedHashMap<String, List<ColumnIdentifier>>();
        this.databaseHandler = databaseHandler;
    }

    public void setConnectionEntry(ConnectionEntry entry) {
        try {
            this.databaseHandler = DatabaseHandler.getConnectedDatabaseHandler(entry);
            if (!"false".equals(System.getProperty("rapidminer.gui.fetch_data_base_table_names"))) {
                this.retrieveTableAndAttributeNames();
            }
        }
        catch (SQLException e) {
            SwingTools.showSimpleErrorMessage("db_connection_failed_url", (Throwable)e, entry.getURL());
            this.databaseHandler = null;
        }
    }

    public JPanel makeQueryBuilderPanel() {
        return this.makeQueryBuilderPanel(false);
    }

    public JPanel makeQueryBuilderPanel(boolean editOnly) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        if (!editOnly) {
            JPanel gridPanel = new JPanel(SQLQueryBuilder.createGridLayout(1, 3));
            this.tableList.setSelectionMode(2);
            this.tableList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SQLQueryBuilder.this.updateAttributeNames();
                    SQLQueryBuilder.this.updateSQLQuery();
                }
            });
            ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.tableList);
            tablePane.setBorder(SQLQueryBuilder.createTitledBorder("Tables"));
            gridPanel.add(tablePane);
            this.attributeList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SQLQueryBuilder.this.updateSQLQuery();
                }
            });
            ExtendedJScrollPane attributePane = new ExtendedJScrollPane(this.attributeList);
            attributePane.setBorder(SQLQueryBuilder.createTitledBorder("Attributes"));
            gridPanel.add(attributePane);
            this.whereTextArea.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    SQLQueryBuilder.this.updateSQLQuery();
                }
            });
            ExtendedJScrollPane whereTextPane = new ExtendedJScrollPane(this.whereTextArea);
            whereTextPane.setBorder(SQLQueryBuilder.createTitledBorder("Where Clause"));
            gridPanel.add(whereTextPane);
            c.weighty = 0.5;
            c.gridwidth = 0;
            panel.add((Component)gridPanel, c);
        }
        c.weighty = 1.0;
        this.sqlQueryTextArea.setBorder(SQLQueryBuilder.createTitledBorder("SQL Query"));
        panel.add((Component)this.sqlQueryTextArea, c);
        return panel;
    }

    private void updateAttributeNames() {
        Object[] selection;
        LinkedList<ColumnIdentifier> allColumnIdentifiers = new LinkedList<ColumnIdentifier>();
        for (Object o : selection = this.tableList.getSelectedValues()) {
            String tableName = (String)o;
            List<ColumnIdentifier> attributeNames = this.attributeNameMap.get(tableName);
            if (attributeNames == null) continue;
            for (ColumnIdentifier currentIdentifier : attributeNames) {
                allColumnIdentifiers.add(currentIdentifier);
            }
        }
        this.attributeList.removeAll();
        ColumnIdentifier[] identifierArray = new ColumnIdentifier[allColumnIdentifiers.size()];
        allColumnIdentifiers.toArray(identifierArray);
        this.attributeList.setListData(identifierArray);
    }

    private void appendAttributeName(StringBuffer result, ColumnIdentifier identifier, boolean first, boolean singleTable) {
        if (!first) {
            result.append(", ");
        }
        if (singleTable) {
            result.append(identifier.getFullName(singleTable));
        } else {
            result.append(identifier.getFullName(singleTable) + " AS " + identifier.getAliasName(singleTable));
        }
    }

    private void updateSQLQuery() {
        boolean first;
        this.fireStateChanged();
        Object[] tableSelection = this.tableList.getSelectedValues();
        if (tableSelection.length == 0) {
            this.sqlQueryTextArea.setText("");
            return;
        }
        boolean singleTable = tableSelection.length == 1;
        StringBuffer result = new StringBuffer("SELECT ");
        Object[] attributeSelection = this.attributeList.getSelectedValues();
        if (singleTable && (attributeSelection.length == 0 || attributeSelection.length == this.attributeList.getModel().getSize())) {
            result.append("*");
        } else if (attributeSelection.length == 0 || attributeSelection.length == this.attributeList.getModel().getSize()) {
            first = true;
            for (int i = 0; i < this.attributeList.getModel().getSize(); ++i) {
                ColumnIdentifier identifier = (ColumnIdentifier)this.attributeList.getModel().getElementAt(i);
                this.appendAttributeName(result, identifier, first, singleTable);
                first = false;
            }
        } else {
            first = true;
            Object[] arr$ = attributeSelection;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Object o = arr$[i$];
                ColumnIdentifier identifier = (ColumnIdentifier)o;
                this.appendAttributeName(result, identifier, first, singleTable);
                first = false;
            }
        }
        result.append(Tools.getLineSeparator() + "FROM ");
        first = true;
        for (Object o : tableSelection) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            String tableName = (String)o;
            result.append(this.databaseHandler.getStatementCreator().makeIdentifier(tableName));
        }
        String whereText = this.whereTextArea.getText().trim();
        if (whereText.length() > 0) {
            result.append(Tools.getLineSeparator() + "WHERE " + whereText);
        }
        this.sqlQueryTextArea.setText(result.toString());
    }

    private void retrieveTableAndAttributeNames() throws SQLException {
        if (this.databaseHandler != null) {
            ProgressThread retrieveTablesThread = new ProgressThread("fetching_database_tables"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.getProgressListener().setTotal(100);
                    this.getProgressListener().setCompleted(10);
                    try {
                        SQLQueryBuilder.this.attributeNameMap.clear();
                        if (SQLQueryBuilder.this.databaseHandler != null) {
                            try {
                                Map<String, List<ColumnIdentifier>> newAttributeMap = SQLQueryBuilder.this.databaseHandler.getAllTableMetaData(this.getProgressListener(), 10, 100, true);
                                SQLQueryBuilder.this.attributeNameMap.putAll(newAttributeMap);
                            }
                            catch (SQLException e) {
                                SwingTools.showSimpleErrorMessage("db_connection_failed_simple", (Throwable)e, e.getMessage());
                            }
                        }
                        final String[] allNames = new String[SQLQueryBuilder.this.attributeNameMap.size()];
                        SQLQueryBuilder.this.attributeNameMap.keySet().toArray(allNames);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLQueryBuilder.this.tableList.removeAll();
                                SQLQueryBuilder.this.tableList.setListData(allNames);
                            }
                        });
                    }
                    finally {
                        this.getProgressListener().complete();
                    }
                }
            };
            retrieveTablesThread.start();
        }
    }

    public void setQuery(String query) {
        this.sqlQueryTextArea.setText(query);
    }

    public String getQuery() {
        return this.sqlQueryTextArea.getText();
    }
}

