/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class MultiPageDialog
extends ButtonDialog
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private int currentStep;
    private JPanel cardPanel;
    private final JButton previous = new JButton(new ResourceAction("previous", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiPageDialog.this.previous();
        }
    });
    private final JButton next = new JButton(new ResourceAction("next", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiPageDialog.this.next();
        }
    });
    private final JButton finish = new JButton(new ResourceAction("finish", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiPageDialog.this.finish();
        }
    });

    public MultiPageDialog(Dialog owner, String key, boolean modal, Object ... arguments) {
        super(key, modal, arguments);
    }

    public MultiPageDialog(Dialog owner, String key, Object ... arguments) {
        super(key, arguments);
    }

    public MultiPageDialog(Frame owner, String key, boolean modal, Object ... arguments) {
        super(key, modal, arguments);
    }

    public MultiPageDialog(Frame owner, String key, Object ... arguments) {
        super(key, arguments);
    }

    protected abstract boolean isComplete();

    protected abstract boolean isLastStep(int var1);

    protected abstract String getNameForStep(int var1);

    protected boolean canProceed(int step) {
        return true;
    }

    protected boolean canGoBack(int step) {
        return true;
    }

    protected void layoutDefault(Map<String, Component> cards) {
        this.layoutDefault(cards, 8);
    }

    protected void layoutDefault(Map<String, Component> cards, int size) {
        this.cardPanel = new JPanel(new CardLayout());
        for (Map.Entry<String, Component> entry : cards.entrySet()) {
            this.cardPanel.add(entry.getValue(), entry.getKey());
        }
        this.showCurrent();
        super.layoutDefault((JComponent)this.cardPanel, size, this.previous, this.next, this.finish, this.makeCancelButton());
    }

    protected int getCurrentStep() {
        return this.currentStep;
    }

    private void showCurrent() {
        this.updateButtons();
        if (this.isLastStep(this.currentStep)) {
            this.getRootPane().setDefaultButton(this.finish);
        } else {
            this.getRootPane().setDefaultButton(this.next);
        }
        String key = this.getNameForStep(this.getCurrentStep());
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, key);
    }

    protected void finish() {
        this.wasConfirmed = true;
        this.dispose();
    }

    protected void previous() {
        --this.currentStep;
        this.showCurrent();
    }

    protected void next() {
        ++this.currentStep;
        this.showCurrent();
    }

    private void updateButtons() {
        this.previous.setEnabled(this.currentStep > 0 && this.canGoBack(this.currentStep));
        this.next.setEnabled(!this.isLastStep(this.currentStep) && this.canProceed(this.currentStep));
        this.finish.setEnabled(this.isComplete() && this.canProceed(this.currentStep));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateButtons();
    }
}

