/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Driver;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageDatabaseDriversDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private JList availableDrivers;
    public static final Action SHOW_DIALOG_ACTION = new ResourceAction("manage_database_drivers", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            new ManageDatabaseDriversDialog().setVisible(true);
        }
    };
    private boolean needsRestart = false;
    private DriverPane driverPane = new DriverPane();
    private AbstractButton deleteButton = new JButton(new ResourceAction("manage_database_drivers.delete", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JDBCProperties props = ManageDatabaseDriversDialog.this.driverPane.properties;
            if (props != null && props.isUserDefined()) {
                ((DefaultListModel)ManageDatabaseDriversDialog.this.availableDrivers.getModel()).removeElement(props);
                DatabaseService.removeJDBCProperties(props);
            }
        }
    });

    public ManageDatabaseDriversDialog() {
        super("manage_database_drivers", new Object[0]);
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipady = 5;
        c.ipadx = 5;
        c.insets = new Insets(5, 5, 5, 5);
        DefaultListModel<JDBCProperties> model = new DefaultListModel<JDBCProperties>();
        for (JDBCProperties props : DatabaseService.getJDBCProperties()) {
            model.addElement(props);
        }
        this.availableDrivers = new JList(model);
        this.availableDrivers.setSelectionMode(0);
        this.availableDrivers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JDBCProperties selected = (JDBCProperties)ManageDatabaseDriversDialog.this.availableDrivers.getSelectedValue();
                ManageDatabaseDriversDialog.this.driverPane.setProperties(selected);
            }
        });
        c.anchor = 23;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = -1;
        main.add((Component)new JScrollPane(this.availableDrivers), c);
        c.gridwidth = 0;
        main.add((Component)this.driverPane, c);
        JButton addButton = new JButton(new ResourceAction("manage_database_drivers.add", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCProperties newProps = new JDBCProperties(true);
                ((DefaultListModel)ManageDatabaseDriversDialog.this.availableDrivers.getModel()).addElement(newProps);
                ManageDatabaseDriversDialog.this.availableDrivers.setSelectedValue(newProps, true);
                DatabaseService.addJDBCProperties(newProps);
            }
        });
        JButton saveButton = new JButton(new ResourceAction("manage_database_drivers.save", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ManageDatabaseDriversDialog.this.driverPane.save();
                    DatabaseService.saveUserDefinedProperties();
                    ManageDatabaseDriversDialog.this.needsRestart = true;
                    ManageDatabaseDriversDialog.this.dispose();
                }
                catch (XMLException e1) {
                    SwingTools.showSimpleErrorMessage("manage_database_drivers.error_saving", (Throwable)e1, e1.getMessage());
                }
            }
        });
        this.layoutDefault((JComponent)main, addButton, this.deleteButton, saveButton, this.makeCloseButton());
        this.driverPane.setProperties(null);
    }

    @Override
    public void close() {
        if (this.needsRestart && SwingTools.showConfirmDialog("manage_database_drivers.restart", 0, new Object[0]) == 0) {
            super.close();
            RapidMinerGUI.getMainFrame().exit(true);
        } else {
            super.close();
        }
    }

    private List<String> findDrivers(final File file) {
        final LinkedList<String> driverNames = new LinkedList<String>();
        new ProgressThread("manage_database_drivers.scan_jar", true){

            @Override
            public void run() {
                try {
                    ClassLoader ucl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            try {
                                return new URLClassLoader(new URL[]{file.toURI().toURL()});
                            }
                            catch (MalformedURLException e) {
                                throw new RuntimeException("Cannot create class loader for file '" + file + "': " + e.getMessage(), e);
                            }
                        }
                    });
                    try {
                        JarFile jarFile = new JarFile(file);
                        Tools.findImplementationsInJar(ucl, jarFile, Driver.class, driverNames);
                    }
                    catch (Exception e) {
                        LogService.getRoot().log(Level.WARNING, "Cannot scan jar file '" + file + "' for drivers: " + e.getMessage(), e);
                    }
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Cannot create class loader for file '" + file + "': " + e.getMessage(), e);
                }
            }
        }.startAndWait();
        return driverNames;
    }

    private class DriverPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JDBCProperties properties;
        private JTextField nameField = new JTextField(20);
        private JTextField urlprefixField = new JTextField(20);
        private JTextField portField = new JTextField(20);
        private JTextField jarFileField = new JTextField(20);
        private JTextField dbseparatorField = new JTextField(20);
        private JComboBox classNameCombo = new JComboBox();

        public DriverPane() {
            this.setLayout(new GridBagLayout());
            this.classNameCombo.setEditable(true);
            JButton fileButton = new JButton(new ResourceAction(true, "manage_database_drivers.jarfile", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = SwingTools.chooseFile(DriverPane.this, null, true, "jar", "JDBC driver jar file");
                    if (file != null) {
                        DriverPane.this.jarFileField.setText(file.getAbsolutePath());
                        ((DefaultComboBoxModel)DriverPane.this.classNameCombo.getModel()).removeAllElements();
                        for (String driver : ManageDatabaseDriversDialog.this.findDrivers(file)) {
                            ((DefaultComboBoxModel)DriverPane.this.classNameCombo.getModel()).addElement(driver);
                        }
                    }
                }
            });
            this.add("name", this.nameField, null);
            this.add("urlprefix", this.urlprefixField, null);
            this.add("port", this.portField, null);
            this.add("dbseparator", this.dbseparatorField, null);
            this.add("jarfile", this.jarFileField, fileButton);
            this.add("classname", this.classNameCombo, null);
        }

        private void add(String labelKey, JComponent component, JComponent button) {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.weightx = 0.5;
            c.weighty = 1.0;
            c.fill = 1;
            c.gridheight = 1;
            ResourceLabel label = new ResourceLabel("manage_database_drivers." + labelKey, new Object[0]);
            label.setLabelFor(component);
            c.gridwidth = 0;
            this.add((Component)label, c);
            c.insets = new Insets(0, 0, 5, 0);
            if (button == null) {
                c.gridwidth = 0;
                this.add((Component)component, c);
            } else {
                c.gridwidth = -1;
                c.weightx = 1.0;
                this.add((Component)component, c);
                c.gridwidth = 0;
                c.weightx = 0.0;
                this.add((Component)button, c);
            }
        }

        private void setProperties(JDBCProperties props) {
            if (this.properties != props) {
                this.save();
            }
            this.properties = props;
            ((DefaultComboBoxModel)this.classNameCombo.getModel()).removeAllElements();
            if (props == null) {
                SwingTools.setEnabledRecursive(this, false);
                this.nameField.setText("");
                this.urlprefixField.setText("");
                this.portField.setText("");
                this.classNameCombo.setSelectedItem("");
                this.jarFileField.setText("");
                this.dbseparatorField.setText("/");
            } else {
                this.nameField.setText(props.getName());
                this.urlprefixField.setText(props.getUrlPrefix());
                this.portField.setText(props.getDefaultPort());
                this.classNameCombo.setSelectedItem(Tools.toString(props.getDriverClasses(), ","));
                this.jarFileField.setText(props.getDriverJarFile());
                this.dbseparatorField.setText(props.getDbNameSeperator());
                if (props.isUserDefined()) {
                    SwingTools.setEnabledRecursive(this, true);
                } else {
                    SwingTools.setEnabledRecursive(this, false);
                }
            }
            ManageDatabaseDriversDialog.this.deleteButton.setEnabled(props != null && props.isUserDefined());
        }

        private void save() {
            if (this.properties != null && this.properties.isUserDefined()) {
                this.properties.setName(this.nameField.getText());
                this.properties.setUrlPrefix(this.urlprefixField.getText());
                this.properties.setDefaultPort(this.portField.getText());
                this.properties.setDriverJarFile(this.jarFileField.getText());
                this.properties.setDbNameSeperator(this.dbseparatorField.getText());
                String className = (String)this.classNameCombo.getSelectedItem();
                if (className != null) {
                    this.properties.setDriverClasses(className);
                }
            }
        }
    }
}

