/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.NoBugError;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.BugAssistant;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.LinkButton;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtendedErrorDialog
extends ButtonDialog {
    private static final long serialVersionUID = -8136329951869702133L;
    private static final int SIZE = 8;
    private final JButton editButton = new JButton("Edit");
    private Throwable error;
    private final JComponent mainComponent = new JPanel(new BorderLayout());

    public ExtendedErrorDialog(String key, Throwable error, Object ... arguments) {
        this(key, error, false, arguments);
    }

    public ExtendedErrorDialog(String key, Throwable error, boolean displayExceptionMessage, Object ... arguments) {
        super("error." + key, true, arguments);
        JComponent detailedPane;
        this.error = error;
        boolean hasError = error != null;
        JComponent jComponent = detailedPane = hasError ? this.createDetailPanel(error) : null;
        if (error != null && error instanceof UserError && ((UserError)error).getOperator() != null) {
            final String opName = ((UserError)error).getOperator().getName();
            this.mainComponent.add((Component)new LinkButton(new ResourceAction("show_offending_operator", new Object[]{opName}){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame mainFrame = RapidMinerGUI.getMainFrame();
                    mainFrame.selectOperator(mainFrame.getProcess().getOperator(opName));
                }
            }), "North");
        }
        this.layoutDefault(this.mainComponent, 8, this.getButtons(hasError && displayExceptionMessage, this.isBugReportException(error), detailedPane, error));
        this.pack();
    }

    public ExtendedErrorDialog(String key, String errorMessage, Object ... arguments) {
        super("error." + key, true, arguments);
        boolean hasError = errorMessage != null && !errorMessage.isEmpty();
        JScrollPane detailedPane = hasError ? this.createDetailPanel(errorMessage) : null;
        this.layoutDefault(this.mainComponent, 8, this.getButtons(hasError, false, detailedPane, null));
    }

    @Override
    protected Icon getInfoIcon() {
        return SwingTools.createIcon("48/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.error.icon", new Object[0]));
    }

    private JComponent createDetailPanel(Throwable error) {
        StackTraceList stl = new StackTraceList(error);
        ExtendedJScrollPane detailPane = new ExtendedJScrollPane(stl);
        detailPane.setPreferredSize(new Dimension(this.getWidth(), 200));
        return detailPane;
    }

    private JScrollPane createDetailPanel(String errorMessage) {
        JTextArea textArea = new JTextArea(errorMessage);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        ExtendedJScrollPane detailPane = new ExtendedJScrollPane(textArea);
        detailPane.setPreferredSize(new Dimension(this.getWidth(), 200));
        return detailPane;
    }

    private Collection<AbstractButton> getButtons(boolean hasError, boolean isBug, final JComponent detailedPane, final Throwable error) {
        LinkedList<AbstractButton> buttons = new LinkedList<AbstractButton>();
        if (hasError) {
            buttons.add(new JToggleButton(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.error.show_details.label", new Object[0]), SwingTools.createIcon("24/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.error.show_details.icon", new Object[0]))){
                private static final long serialVersionUID = 8889251336231161227L;
                private boolean detailsShown;
                {
                    super(x0, x1);
                    this.detailsShown = false;
                    this.setSelected(false);
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (detailsShown) {
                                ExtendedErrorDialog.this.mainComponent.remove(detailedPane);
                                ExtendedErrorDialog.this.setDefaultSize(4);
                            } else {
                                ExtendedErrorDialog.this.mainComponent.add((Component)detailedPane, "Center");
                                ExtendedErrorDialog.this.setDefaultSize(5);
                            }
                            detailsShown = !detailsShown;
                        }
                    });
                }
            });
        }
        if (isBug) {
            buttons.add(new JButton(new ResourceAction("send_bugreport", new Object[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    new BugAssistant(error).setVisible(true);
                }
            }));
        }
        buttons.add(this.makeCloseButton());
        return buttons;
    }

    private boolean isBugReportException(Throwable t) {
        return !(t instanceof NoBugError) && !(t instanceof XMLException);
    }

    @Override
    protected String getInfoText() {
        if (this.error != null) {
            Throwable cause;
            StringBuilder infoText = new StringBuilder();
            infoText.append("<div><strong>");
            infoText.append(super.getInfoText());
            infoText.append("</strong></div>");
            if (this.arguments.length == 0 && this.error.getMessage() != null && this.error.getMessage().length() > 0) {
                infoText.append("<p>");
                infoText.append(Tools.escapeHTML(this.error.getMessage()));
                infoText.append("</p>");
            }
            if ((cause = this.error.getCause()) != null) {
                String message = Tools.escapeHTML(cause.getMessage());
                if (message == null) {
                    message = cause.toString();
                }
                if (!"null".equals(message)) {
                    infoText.append("<p><strong>Reason: </strong>");
                    infoText.append(message);
                    infoText.append("</p>");
                }
            }
            return infoText.toString();
        }
        return super.getInfoText();
    }

    private class StackTraceList
    extends JList {
        private static final long serialVersionUID = -2482220036723949144L;

        public StackTraceList(Throwable t) {
            super(new DefaultListModel());
            this.setFont(this.getFont().deriveFont(0));
            this.setSelectionMode(2);
            this.appendAllStackTraces(t);
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (StackTraceList.this.getSelectedIndex() >= 0) {
                        if (!(StackTraceList.this.getSelectedValue() instanceof FormattedStackTraceElement)) {
                            ExtendedErrorDialog.this.editButton.setEnabled(false);
                        } else {
                            ExtendedErrorDialog.this.editButton.setEnabled(true);
                        }
                    } else {
                        ExtendedErrorDialog.this.editButton.setEnabled(true);
                    }
                }
            });
        }

        private DefaultListModel model() {
            return (DefaultListModel)this.getModel();
        }

        private void appendAllStackTraces(Throwable throwable) {
            while (throwable != null) {
                this.appendStackTrace(throwable);
                if ((throwable = throwable.getCause()) == null) continue;
                this.model().addElement("");
                this.model().addElement("Cause");
            }
        }

        private void appendStackTrace(Throwable throwable) {
            this.model().addElement("Exception: " + throwable.getClass().getName());
            this.model().addElement("Message: " + throwable.getMessage());
            this.model().addElement("Stack trace:" + Tools.getLineSeparator());
            for (int i = 0; i < throwable.getStackTrace().length; ++i) {
                this.model().addElement(new FormattedStackTraceElement(throwable.getStackTrace()[i]));
            }
        }
    }

    private static class FormattedStackTraceElement {
        private final StackTraceElement ste;

        private FormattedStackTraceElement(StackTraceElement ste) {
            this.ste = ste;
        }

        public String toString() {
            return "  " + this.ste;
        }
    }
}

