/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class DecisionRememberingConfirmDialog
extends ButtonDialog {
    public static final String[] PROPERTY_VALUES = new String[]{"true", "false", "ask"};
    private static final long serialVersionUID = 1L;
    public static final int TRUE = 0;
    public static final int FALSE = 1;
    public static final int ASK = 2;
    private final JCheckBox dontAskAgainBox;
    private final String propertyName;
    private boolean confirmed;

    private DecisionRememberingConfirmDialog(String i18nKey, String property) {
        super(i18nKey, true, new Object[0]);
        this.propertyName = property;
        this.dontAskAgainBox = new JCheckBox(new ResourceActionAdapter("remember_decision", new Object[0]));
        this.dontAskAgainBox.setSelected(false);
        JButton yesButton = this.makeOkButton("yes");
        JButton noButton = this.makeCancelButton("no");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.dontAskAgainBox, "West");
        buttonPanel.add((Component)this.makeButtonPanel(yesButton, noButton), "East");
        this.layoutDefault(null, buttonPanel);
        noButton.requestFocusInWindow();
    }

    @Override
    public void ok() {
        this.confirmed = true;
        this.saveIfDesired();
        this.dispose();
    }

    @Override
    public void cancel() {
        this.confirmed = false;
        this.saveIfDesired();
        this.dispose();
    }

    private void saveIfDesired() {
        if (this.dontAskAgainBox.isSelected()) {
            String value = this.confirmed ? "true" : "false";
            System.setProperty(this.propertyName, value);
            ParameterService.writePropertyIntoMainUserConfigFile(this.propertyName, value);
        }
    }

    public static boolean confirmAction(String i18nKey, String propertyKey) {
        String propValue = System.getProperty(propertyKey);
        if (propValue != null) {
            if (propValue.equals("true")) {
                return true;
            }
            if (propValue.equals("false")) {
                return false;
            }
        }
        DecisionRememberingConfirmDialog d = new DecisionRememberingConfirmDialog(i18nKey, propertyKey);
        d.setVisible(true);
        return d.confirmed;
    }
}

