/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.FilterableListModel;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.FixedWidthLabel;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.MultiConfirmDialog;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.JDBCProperties;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import com.rapidminer.tools.jdbc.connection.FieldConnectionEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DatabaseConnectionDialog
extends ButtonDialog {
    private static final long serialVersionUID = -2046390670591412166L;
    private static final String TEXT_CONNECTION_STATUS_UNKNOWN = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.manage_db_connections.status.unknown.label", new Object[0]);
    private static final String TEXT_CONNECTION_STATUS_OK = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.manage_db_connections.status.ok.label", new Object[0]);
    private static final Icon ICON_CONNECTION_STATUS_UNKNOWN = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.manage_db_connections.status.unknown.icon", new Object[0]));
    private static final Icon ICON_CONNECTION_STATUS_OK = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.manage_db_connections.status.ok.icon", new Object[0]));
    private static final Icon ICON_CONNECTION_STATUS_ERROR = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.manage_db_connections.status.error.icon", new Object[0]));
    private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
    private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
    private final FilterableListModel model = new FilterableListModel();
    private final JList connectionList;
    private final JTextField aliasTextField;
    private final JComboBox databaseTypeComboBox;
    private final JTextField hostTextField;
    private final JTextField portTextField;
    private final JTextField databaseTextField;
    private final JTextField userTextField;
    private final JPasswordField passwordField;
    private final JTextField urlField;
    private final JLabel testLabel;
    private final Action OPEN_CONNECTION_ACTION;
    private final Action SAVE_CONNECTION_ACTION;
    private final Action NEW_CONNECTION_ACTION;
    private final Action DELETE_CONNECTION_ACTION;
    private final Action TEST_CONNECTION_ACTION;

    public DatabaseConnectionDialog(String i18nKey, Object ... i18nArgs) {
        super(i18nKey, true, i18nArgs);
        for (FieldConnectionEntry entry : DatabaseConnectionService.getConnectionEntries()) {
            this.model.addElement(entry);
        }
        this.connectionList = new JList(this.model);
        this.connectionList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 4616183160018529751L;
            private final Icon entryIcon = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.manage_db_connections.connection_entry.icon", new Object[0]));

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (isSelected) {
                    label.setForeground(TEXT_SELECTED_COLOR);
                } else {
                    label.setForeground(TEXT_NON_SELECTED_COLOR);
                }
                if (value instanceof FieldConnectionEntry) {
                    FieldConnectionEntry entry = (FieldConnectionEntry)value;
                    String readOnly = entry.isReadOnly() ? "*" : "";
                    label.setText("<html>" + entry.getName() + readOnly + " <small>(" + entry.getProperties().getName() + "; " + entry.getHost() + ":" + entry.getPort() + ")</small></html>");
                    label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                    label.setIcon(this.entryIcon);
                }
                return label;
            }
        });
        this.connectionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DatabaseConnectionDialog.this.OPEN_CONNECTION_ACTION.actionPerformed(null);
                }
            }
        });
        this.connectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean selected = DatabaseConnectionDialog.this.connectionList.getSelectedValue() != null;
                DatabaseConnectionDialog.this.OPEN_CONNECTION_ACTION.setEnabled(selected);
                if (selected) {
                    selected = !((FieldConnectionEntry)DatabaseConnectionDialog.this.connectionList.getSelectedValue()).isReadOnly();
                }
                DatabaseConnectionDialog.this.DELETE_CONNECTION_ACTION.setEnabled(selected);
            }
        });
        this.aliasTextField = new JTextField(12);
        this.databaseTypeComboBox = new JComboBox<String>(DatabaseService.getDBSystemNames());
        this.hostTextField = new JTextField(12);
        this.portTextField = new JTextField(4);
        this.databaseTextField = new JTextField(12);
        this.userTextField = new JTextField(12);
        this.passwordField = new JPasswordField(12);
        this.urlField = new JTextField(12);
        this.testLabel = new FixedWidthLabel(280, TEXT_CONNECTION_STATUS_UNKNOWN, ICON_CONNECTION_STATUS_UNKNOWN);
        this.urlField.setEditable(false);
        this.databaseTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DatabaseConnectionDialog.this.updateDefaults();
                DatabaseConnectionDialog.this.updateURL(null);
            }
        });
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatabaseConnectionDialog.this.updateURL(null);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.portTextField.addKeyListener(keyListener);
        this.hostTextField.addKeyListener(keyListener);
        this.databaseTextField.addKeyListener(keyListener);
        this.userTextField.addKeyListener(keyListener);
        this.passwordField.addKeyListener(keyListener);
        this.OPEN_CONNECTION_ACTION = new ResourceAction("manage_db_connections.open", new Object[0]){
            private static final long serialVersionUID = 2451337494765496601L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = DatabaseConnectionDialog.this.connectionList.getSelectedValue();
                if (value instanceof FieldConnectionEntry) {
                    FieldConnectionEntry entry = (FieldConnectionEntry)value;
                    DatabaseConnectionDialog.this.aliasTextField.setText(entry.getName());
                    DatabaseConnectionDialog.this.databaseTypeComboBox.setSelectedItem(entry.getProperties().getName());
                    DatabaseConnectionDialog.this.hostTextField.setText(entry.getHost());
                    DatabaseConnectionDialog.this.portTextField.setText(entry.getPort());
                    DatabaseConnectionDialog.this.databaseTextField.setText(entry.getDatabase());
                    DatabaseConnectionDialog.this.userTextField.setText(entry.getUser());
                    if (entry.getPassword() == null) {
                        DatabaseConnectionDialog.this.passwordField.setText("");
                    } else {
                        DatabaseConnectionDialog.this.passwordField.setText(new String(entry.getPassword()));
                    }
                    DatabaseConnectionDialog.this.aliasTextField.setEditable(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.databaseTypeComboBox.setEnabled(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.hostTextField.setEditable(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.portTextField.setEditable(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.databaseTextField.setEditable(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.userTextField.setEditable(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.passwordField.setEditable(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.SAVE_CONNECTION_ACTION.setEnabled(!entry.isReadOnly());
                    DatabaseConnectionDialog.this.updateURL(entry);
                }
            }
        };
        this.SAVE_CONNECTION_ACTION = new ResourceAction("manage_db_connections.save", new Object[0]){
            private static final long serialVersionUID = -8477647509533859436L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FieldConnectionEntry entry = DatabaseConnectionDialog.this.checkFields(true);
                if (entry != null) {
                    ConnectionEntry sameNameEntry = null;
                    for (int i = 0; i < DatabaseConnectionDialog.this.model.getSize(); ++i) {
                        ConnectionEntry compareEntry = (ConnectionEntry)DatabaseConnectionDialog.this.model.getElementAt(i);
                        if (!compareEntry.getName().equals(entry.getName())) continue;
                        sameNameEntry = compareEntry;
                        break;
                    }
                    if (sameNameEntry == null) {
                        DatabaseConnectionDialog.this.model.addElement(entry);
                        DatabaseConnectionService.addConnectionEntry(entry);
                    } else if (SwingTools.showConfirmDialog("manage_db_connections.overwrite", 0, entry.getName()) == 0) {
                        DatabaseConnectionService.deleteConnectionEntry(sameNameEntry);
                        DatabaseConnectionDialog.this.model.removeElement(sameNameEntry);
                        DatabaseConnectionDialog.this.model.addElement(entry);
                        DatabaseConnectionService.addConnectionEntry(entry);
                    }
                }
            }
        };
        this.NEW_CONNECTION_ACTION = new ResourceAction("manage_db_connections.new", new Object[0]){
            private static final long serialVersionUID = -6286464201049577441L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseConnectionDialog.this.databaseTypeComboBox.setSelectedIndex(0);
                DatabaseConnectionDialog.this.aliasTextField.setText("");
                DatabaseConnectionDialog.this.hostTextField.setText("");
                DatabaseConnectionDialog.this.portTextField.setText("");
                DatabaseConnectionDialog.this.databaseTextField.setText("");
                DatabaseConnectionDialog.this.userTextField.setText("");
                DatabaseConnectionDialog.this.passwordField.setText("");
                DatabaseConnectionDialog.this.aliasTextField.setEditable(true);
                DatabaseConnectionDialog.this.databaseTypeComboBox.setEnabled(true);
                DatabaseConnectionDialog.this.hostTextField.setEditable(true);
                DatabaseConnectionDialog.this.portTextField.setEditable(true);
                DatabaseConnectionDialog.this.databaseTextField.setEditable(true);
                DatabaseConnectionDialog.this.userTextField.setEditable(true);
                DatabaseConnectionDialog.this.passwordField.setEditable(true);
                DatabaseConnectionDialog.this.SAVE_CONNECTION_ACTION.setEnabled(true);
                DatabaseConnectionDialog.this.updateDefaults();
                DatabaseConnectionDialog.this.updateURL(null);
            }
        };
        this.DELETE_CONNECTION_ACTION = new ResourceAction("manage_db_connections.delete", new Object[0]){
            private static final long serialVersionUID = 1155260480975020776L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedValues = DatabaseConnectionDialog.this.connectionList.getSelectedValues();
                boolean applyToAll = false;
                int returnOption = 2;
                for (int i = 0; i < selectedValues.length; ++i) {
                    ConnectionEntry entry = (ConnectionEntry)selectedValues[i];
                    if (!applyToAll) {
                        MultiConfirmDialog dialog = new MultiConfirmDialog("manage_db_connections.delete", 1, new Object[]{entry.getName()});
                        dialog.setVisible(true);
                        applyToAll = dialog.applyToAll();
                        returnOption = dialog.getReturnOption();
                    }
                    if (returnOption == 2) break;
                    if (returnOption != 0) continue;
                    DatabaseConnectionService.deleteConnectionEntry(entry);
                    DatabaseConnectionDialog.this.model.removeElement(entry);
                    DatabaseConnectionDialog.this.connectionList.clearSelection();
                    for (int j = 0; j < selectedValues.length; ++j) {
                        int index = DatabaseConnectionDialog.this.model.indexOf(selectedValues[j]);
                        DatabaseConnectionDialog.this.connectionList.getSelectionModel().addSelectionInterval(index, index);
                    }
                }
            }
        };
        this.TEST_CONNECTION_ACTION = new ResourceAction("manage_db_connections.test", new Object[0]){
            private static final long serialVersionUID = -25485375154547037L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressThread t = new ProgressThread("test_database_connection"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.getProgressListener().setTotal(100);
                        this.getProgressListener().setCompleted(10);
                        try {
                            FieldConnectionEntry entry = DatabaseConnectionDialog.this.checkFields(false);
                            if (entry == null) {
                                return;
                            }
                            if (!DatabaseConnectionService.testConnection(entry)) {
                                throw new SQLException();
                            }
                            DatabaseConnectionDialog.this.testLabel.setText(TEXT_CONNECTION_STATUS_OK);
                            DatabaseConnectionDialog.this.testLabel.setIcon(ICON_CONNECTION_STATUS_OK);
                        }
                        catch (SQLException exception) {
                            String errorMessage = exception.getLocalizedMessage();
                            if (errorMessage.length() > 100) {
                                errorMessage = exception.getLocalizedMessage().substring(0, 100) + "...";
                            }
                            DatabaseConnectionDialog.this.testLabel.setText(errorMessage);
                            DatabaseConnectionDialog.this.testLabel.setIcon(ICON_CONNECTION_STATUS_ERROR);
                        }
                        finally {
                            this.getProgressListener().complete();
                        }
                    }
                };
                t.start();
            }
        };
        this.OPEN_CONNECTION_ACTION.setEnabled(false);
        this.DELETE_CONNECTION_ACTION.setEnabled(false);
    }

    public Collection<AbstractButton> makeButtons() {
        LinkedList<AbstractButton> list = new LinkedList<AbstractButton>();
        list.add(new JButton(this.OPEN_CONNECTION_ACTION));
        list.add(new JButton(this.SAVE_CONNECTION_ACTION));
        list.add(new JButton(this.NEW_CONNECTION_ACTION));
        list.add(new JButton(this.DELETE_CONNECTION_ACTION));
        list.add(new JButton(this.TEST_CONNECTION_ACTION));
        return list;
    }

    private JPanel makeConnectionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(DatabaseConnectionDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.border.manage_db_connections.details", new Object[0])));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.name", new Object[0]), c);
        c.insets = new Insets(0, 6, 6, 6);
        panel.add((Component)this.aliasTextField, c);
        c.weightx = 1.0;
        c.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.system", new Object[0]), c);
        c.insets = new Insets(0, 6, 0, 6);
        panel.add((Component)this.databaseTypeComboBox, c);
        c.weightx = 0.8;
        c.gridwidth = -1;
        c.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.host", new Object[0]), c);
        c.weightx = 0.2;
        c.gridwidth = 0;
        panel.add((Component)new ResourceLabel("manage_db_connections.port", new Object[0]), c);
        c.weightx = 0.8;
        c.gridwidth = -1;
        c.insets = new Insets(0, 6, 0, 6);
        panel.add((Component)this.hostTextField, c);
        c.weightx = 0.2;
        c.gridwidth = 0;
        panel.add((Component)this.portTextField, c);
        c.weightx = 1.0;
        c.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.database", new Object[0]), c);
        c.insets = new Insets(0, 6, 0, 6);
        panel.add((Component)this.databaseTextField, c);
        c.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.user", new Object[0]), c);
        c.insets = new Insets(0, 6, 0, 6);
        panel.add((Component)this.userTextField, c);
        c.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.password", new Object[0]), c);
        c.insets = new Insets(0, 6, 6, 6);
        panel.add((Component)this.passwordField, c);
        c.insets = new Insets(6, 6, 0, 6);
        panel.add((Component)new ResourceLabel("manage_db_connections.url", new Object[0]), c);
        c.insets = new Insets(0, 6, 6, 6);
        panel.add((Component)this.urlField, c);
        c.weighty = 1.0;
        c.insets = new Insets(0, 12, 6, 6);
        panel.add((Component)this.testLabel, c);
        this.updateDefaults();
        this.updateURL(null);
        return panel;
    }

    public JPanel makeConnectionManagementPanel() {
        JPanel panel = new JPanel(DatabaseConnectionDialog.createGridLayout(1, 2));
        ExtendedJScrollPane connectionListPane = new ExtendedJScrollPane(this.connectionList);
        connectionListPane.setBorder(DatabaseConnectionDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.border.manage_db_connections.connections", new Object[0])));
        panel.add(connectionListPane);
        panel.add(this.makeConnectionPanel());
        return panel;
    }

    private JDBCProperties getProperties() {
        return DatabaseService.getJDBCProperties((String)this.databaseTypeComboBox.getSelectedItem());
    }

    private void updateDefaults() {
        this.portTextField.setText(this.getProperties().getDefaultPort());
    }

    private void updateURL(FieldConnectionEntry entry) {
        if (entry != null && entry.isReadOnly()) {
            this.urlField.setText(entry.getURL());
        } else {
            this.urlField.setText(FieldConnectionEntry.createURL(this.getProperties(), this.hostTextField.getText(), this.portTextField.getText(), this.databaseTextField.getText()));
        }
        this.testLabel.setText(TEXT_CONNECTION_STATUS_UNKNOWN);
        this.testLabel.setIcon(ICON_CONNECTION_STATUS_UNKNOWN);
        this.fireStateChanged();
    }

    protected FieldConnectionEntry checkFields(boolean save) {
        String alias = this.aliasTextField.getText();
        if (save && (alias == null || "".equals(alias.trim()))) {
            SwingTools.showVerySimpleErrorMessage("manage_db_connections.missing", I18N.getMessage(I18N.getGUIBundle(), "gui.label.manage_db_connections.name.label", new Object[0]));
            this.aliasTextField.requestFocusInWindow();
            return null;
        }
        String host = this.hostTextField.getText();
        if (host == null || "".equals(host)) {
            SwingTools.showVerySimpleErrorMessage("manage_db_connections.missing", I18N.getMessage(I18N.getGUIBundle(), "gui.label.manage_db_connections.host.label", new Object[0]));
            this.hostTextField.requestFocusInWindow();
            return null;
        }
        String port = this.portTextField.getText();
        String database = this.databaseTextField.getText();
        if (database == null) {
            database = "";
        }
        String user = this.userTextField.getText();
        char[] password = this.passwordField.getPassword();
        return new FieldConnectionEntry(alias, this.getProperties(), host, port, database, user, password);
    }

    public FieldConnectionEntry getConnectionEntry(boolean save) {
        String database;
        String alias = this.aliasTextField.getText();
        if (save && (alias == null || "".equals(alias.trim()))) {
            return null;
        }
        String host = this.hostTextField.getText();
        if (host == null || "".equals(host)) {
            return null;
        }
        String port = this.portTextField.getText();
        if (host == null) {
            port = "";
        }
        if ((database = this.databaseTextField.getText()) == null) {
            database = "";
        }
        String user = this.userTextField.getText();
        char[] password = this.passwordField.getPassword();
        return new FieldConnectionEntry(alias, this.getProperties(), host, port, database, user, password);
    }
}

