/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ParameterService;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ConfirmDialog
extends ButtonDialog {
    private static final long serialVersionUID = -5825873580778775409L;
    public static final int OK_OPTION = 0;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    private int returnOption = 2;
    private JCheckBox dontAskAgainCheckbox = null;

    public ConfirmDialog(String key, int mode, boolean showAskAgainCheckbox, Object ... arguments) {
        super("confirm." + key, true, arguments);
        LinkedList<AbstractButton> buttons = new LinkedList<AbstractButton>();
        switch (mode) {
            case 2: {
                buttons.add(this.makeOkButton());
                buttons.add(this.makeCancelButton());
                break;
            }
            case 0: {
                buttons.add(this.makeYesButton());
                buttons.add(this.makeNoButton());
                break;
            }
            case 1: {
                buttons.add(this.makeYesButton());
                buttons.add(this.makeNoButton());
                buttons.add(this.makeCancelButton());
            }
        }
        if (showAskAgainCheckbox) {
            this.dontAskAgainCheckbox = new JCheckBox(new ResourceActionAdapter("dont_ask_again", new Object[0]));
        }
        this.layoutDefault((JComponent)this.dontAskAgainCheckbox, buttons);
    }

    @Override
    protected Icon getInfoIcon() {
        String iconKey = I18N.getMessageOrNull(I18N.getGUIBundle(), this.getKey() + ".icon", new Object[0]);
        if (iconKey == null) {
            return SwingTools.createIcon("48/" + I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.confirm.icon", new Object[0]));
        }
        return SwingTools.createIcon("48/" + iconKey);
    }

    @Override
    protected JButton makeOkButton() {
        return new JButton(new ResourceAction("ok", new Object[0]){
            private static final long serialVersionUID = -8887199234055845095L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmDialog.this.returnOption = 0;
                ConfirmDialog.this.ok();
            }
        });
    }

    @Override
    protected JButton makeCancelButton() {
        return new JButton(new ResourceAction("cancel", new Object[0]){
            private static final long serialVersionUID = -8887199234055845095L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmDialog.this.returnOption = 2;
                ConfirmDialog.this.cancel();
            }
        });
    }

    protected JButton makeYesButton() {
        return new JButton(new ResourceAction("confirm.yes", new Object[0]){
            private static final long serialVersionUID = -8887199234055845095L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmDialog.this.returnOption = 0;
                ConfirmDialog.this.yes();
            }
        });
    }

    protected JButton makeNoButton() {
        return new JButton(new ResourceAction("confirm.no", new Object[0]){
            private static final long serialVersionUID = -8887199234055845095L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmDialog.this.returnOption = 1;
                ConfirmDialog.this.no();
            }
        });
    }

    @Override
    protected void ok() {
        this.dispose();
    }

    @Override
    protected void cancel() {
        this.dispose();
    }

    protected void yes() {
        this.dispose();
    }

    protected void no() {
        this.dispose();
    }

    public int getReturnOption() {
        return this.returnOption;
    }

    public static int showConfirmDialog(String key, int mode, String propertyConfirmExit, int defaultOption, Object ... i18nArgs) {
        if (propertyConfirmExit == null) {
            ConfirmDialog dialog = new ConfirmDialog(key, mode, true, i18nArgs);
            dialog.setVisible(true);
            return dialog.getReturnOption();
        }
        String askProperty = System.getProperty(propertyConfirmExit);
        if (!"false".equals(askProperty)) {
            ConfirmDialog dialog = new ConfirmDialog(key, mode, true, i18nArgs);
            dialog.setVisible(true);
            ParameterService.writePropertyIntoMainUserConfigFile(propertyConfirmExit, Boolean.toString(!dialog.dontAskAgainCheckbox.isSelected()));
            return dialog.getReturnOption();
        }
        return defaultOption;
    }
}

