/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.FixedWidthLabel;
import com.rapidminer.tools.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ButtonDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String key = null;
    protected boolean wasConfirmed = false;
    public static final int NORMAL = 1;
    public static final int NARROW = 2;
    public static final int LARGE = 3;
    public static final int HUGE = 9;
    public static final int MESSAGE = 4;
    public static final int MESSAGE_EXTENDED = 5;
    public static final int DEFAULT_SIZE = 8;
    public static final int GAP = 6;
    protected static final Insets INSETS = new Insets(6, 6, 6, 6);
    protected FixedWidthLabel infoTextLabel = null;
    protected final Object[] arguments;
    private Component centerComponent;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public ButtonDialog(String key, Object ... arguments) {
        super(ApplicationFrame.getApplicationFrame(), I18N.getMessage(I18N.getGUIBundle(), "gui.dialog." + key + ".title", arguments), false);
        this.arguments = arguments;
        this.configure(key);
        this.pack();
    }

    public ButtonDialog(String key, boolean modal, Object ... arguments) {
        super(ApplicationFrame.getApplicationFrame(), I18N.getMessage(I18N.getGUIBundle(), "gui.dialog." + key + ".title", arguments), modal);
        this.arguments = arguments;
        this.configure(key);
        this.pack();
    }

    public ButtonDialog(String key, Dialog.ModalityType type, Object ... arguments) {
        super((Window)ApplicationFrame.getApplicationFrame(), I18N.getMessage(I18N.getGUIBundle(), "gui.dialog." + key + ".title", arguments), type);
        this.arguments = arguments;
        this.configure(key);
        this.pack();
    }

    @Deprecated
    public ButtonDialog(Dialog owner, String key, boolean modal, Object ... arguments) {
        this(key, modal, arguments);
    }

    @Deprecated
    public ButtonDialog(Dialog owner, String key, Object ... arguments) {
        this(key, arguments);
    }

    @Deprecated
    public ButtonDialog(Frame owner, String key, boolean modal, Object ... arguments) {
        this(key, modal, arguments);
    }

    @Deprecated
    public ButtonDialog(Frame owner, String key, Object ... arguments) {
        this(key, arguments);
    }

    private void configure(String key) {
        this.key = key;
        this.setDefaultCloseOperation(2);
    }

    protected final String getKey() {
        return "gui.dialog." + this.key;
    }

    protected String getInfoText() {
        return I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".message", this.arguments);
    }

    protected Icon getInfoIcon() {
        return SwingTools.createIcon("48/" + I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".icon", new Object[0]));
    }

    protected String getDialogTitle() {
        return I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".title", this.arguments);
    }

    private JPanel makeInfoPanel() {
        return this.makeInfoPanel(this.getInfoText(), this.getInfoIcon());
    }

    private JPanel makeInfoPanel(String message, Icon icon) {
        int width;
        JLabel infoIcon = new JLabel(icon);
        infoIcon.setVerticalAlignment(1);
        JPanel infoPanel = new JPanel(new BorderLayout(20, 0));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(12, 16, 16, 4));
        infoPanel.add((Component)infoIcon, "West");
        if (this.centerComponent != null) {
            width = (int)this.centerComponent.getPreferredSize().getWidth() - 88;
            if (width < 420) {
                width = 420;
            }
        } else {
            width = 420;
        }
        this.infoTextLabel = new FixedWidthLabel(width, message);
        infoPanel.add((Component)this.infoTextLabel, "Center");
        return infoPanel;
    }

    protected void layoutDefault(JComponent centerComponent, int size, Collection<AbstractButton> buttons) {
        this.layoutDefault(centerComponent, size, buttons.toArray(new AbstractButton[buttons.size()]));
    }

    protected void layoutDefault(JComponent centerComponent, Collection<AbstractButton> buttons) {
        this.layoutDefault(centerComponent, 8, buttons.toArray(new AbstractButton[buttons.size()]));
    }

    protected void layoutDefault(JComponent centerComponent, AbstractButton ... buttons) {
        this.layoutDefault(centerComponent, 8, buttons);
    }

    protected void layoutDefault(JComponent centerComponent, int size, AbstractButton ... buttons) {
        this.layoutDefault(centerComponent, this.makeButtonPanel(buttons), size);
    }

    protected void layoutDefault(JComponent centerComponent, JPanel buttonPanel) {
        this.layoutDefault(centerComponent, buttonPanel, 8);
    }

    protected void layoutDefault(final JComponent centerComponent, JPanel buttonPanel, int size) {
        this.centerComponent = centerComponent;
        this.setTitle(this.getDialogTitle());
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeInfoPanel(), "North");
        if (centerComponent != null) {
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            centerPanel.add((Component)centerComponent, "Center");
            this.add((Component)centerPanel, "Center");
        }
        this.add((Component)buttonPanel, "South");
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (ButtonDialog.this.infoTextLabel != null && centerComponent != null) {
                    ButtonDialog.this.infoTextLabel.setWidth(centerComponent.getWidth() - 88);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        switch (size) {
            case 8: {
                break;
            }
            default: {
                this.setPreferredSize(this.getDefaultSize(size));
            }
        }
        this.pack();
        this.setDefaultLocation();
    }

    protected void setDefaultLocation() {
        this.setLocationRelativeTo(ApplicationFrame.getApplicationFrame());
    }

    protected void setDefaultSize() {
        this.setDefaultSize(1);
    }

    protected Dimension getDefaultSize(int size) {
        switch (size) {
            case 2: {
                return new Dimension(360, 540);
            }
            case 1: {
                return new Dimension(720, 540);
            }
            case 3: {
                return new Dimension(800, 600);
            }
            case 9: {
                return new Dimension(1000, 760);
            }
            case 4: {
                return new Dimension(600, 200);
            }
            case 5: {
                return new Dimension(600, 400);
            }
        }
        return new Dimension(420, 300);
    }

    protected void setDefaultSize(int size) {
        if (size != 8) {
            this.setPreferredSize(this.getDefaultSize(size));
        }
        this.pack();
    }

    protected JPanel makeButtonPanel(Collection<AbstractButton> buttons) {
        return this.makeButtonPanel(buttons.toArray(new AbstractButton[buttons.size()]));
    }

    protected JPanel makeButtonPanel(AbstractButton ... buttons) {
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 6));
        for (AbstractButton button : buttons) {
            buttonPanel.add(button);
        }
        return buttonPanel;
    }

    protected JButton makeOkButton() {
        return this.makeOkButton("ok");
    }

    protected JButton makeOkButton(String i18nKey) {
        ResourceAction okAction = new ResourceAction(i18nKey, new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonDialog.this.wasConfirmed = true;
                ButtonDialog.this.ok();
            }
        };
        JButton button = new JButton(okAction);
        this.getRootPane().setDefaultButton(button);
        return button;
    }

    protected JButton makeCancelButton() {
        return this.makeCancelButton("cancel");
    }

    protected JButton makeCancelButton(String i18nKey) {
        ResourceAction cancelAction = new ResourceAction(i18nKey, new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonDialog.this.wasConfirmed = false;
                ButtonDialog.this.cancel();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", cancelAction);
        return new JButton(cancelAction);
    }

    protected JButton makeCloseButton() {
        ResourceAction Action2 = new ResourceAction("close", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonDialog.this.wasConfirmed = false;
                ButtonDialog.this.close();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "CLOSE");
        this.getRootPane().getActionMap().put("CLOSE", Action2);
        JButton button = new JButton(Action2);
        this.getRootPane().setDefaultButton(button);
        return button;
    }

    protected void cancel() {
        this.dispose();
    }

    protected void ok() {
        this.dispose();
    }

    protected void close() {
        this.dispose();
    }

    public boolean wasConfirmed() {
        return this.wasConfirmed;
    }

    protected void setConfirmed(boolean b) {
        this.wasConfirmed = b;
    }

    public static TitledBorder createTitledBorder(String title) {
        TitledBorder border = new TitledBorder(ButtonDialog.createBorder(), title){
            private static final long serialVersionUID = 3113821577644055057L;

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                super.paintBorder(c, g, x - 2, y, width + 4, height);
            }
        };
        return border;
    }

    public static Border createBorder() {
        return BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY);
    }

    public static GridLayout createGridLayout(int rows, int columns) {
        return new GridLayout(rows, columns, 6, 6);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    protected void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }
}

