/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.dialogs;

import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.LinkButton;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class AboutBox
extends JDialog {
    private static final long serialVersionUID = -3889559376722324215L;
    private static final String PROPERTY_FILE = "about_infos.properties";
    private static final String RAPID_MINER_LOGO_NAME = "rapidminer_logo.png";
    public static final Image RAPID_MINER_LOGO;
    public static Image backgroundImage;
    private ContentPanel contentPanel;

    public AboutBox(Frame owner, String productName, String productVersion, String licensor, String url, String text, boolean renderTextNextToLogo, Image productLogo) {
        this(owner, AboutBox.createProperties(productName, productVersion, licensor, url, text, renderTextNextToLogo), productLogo);
    }

    public AboutBox(Frame owner, String productVersion, Image productLogo) {
        this(owner, AboutBox.createProperties(productVersion), productLogo);
    }

    public AboutBox(Frame owner, Properties properties, Image productLogo) {
        super(owner, "About", true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        String name = properties.getProperty("name");
        if (name != null) {
            this.setTitle("About " + name);
        }
        this.contentPanel = new ContentPanel(properties, productLogo);
        this.add((Component)this.contentPanel, "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        final String url = properties.getProperty("url");
        if (url != null) {
            c.weightx = 1.0;
            c.gridwidth = -1;
            buttonPanel.add((Component)new LinkButton(new ResourceAction("simple_link_action", new Object[]{url}){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }), c);
        }
        ResourceAction closeAction = new ResourceAction("close", new Object[0]){
            private static final long serialVersionUID = 1407089394491740308L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.dispose();
            }
        };
        JButton closeButton = new JButton(closeAction);
        c.weightx = 0.0;
        c.gridwidth = 0;
        buttonPanel.add((Component)closeButton, c);
        this.add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(closeButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "CANCEL");
        this.getRootPane().getActionMap().put("CANCEL", closeAction);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public static Properties createProperties(InputStream inputStream, String productVersion) {
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (Exception e) {
                LogService.getGlobal().logError("Cannot read splash screen infos: " + e.getMessage());
            }
        }
        properties.setProperty("version", productVersion);
        Plugin.initAboutTexts(properties);
        return properties;
    }

    private static Properties createProperties(String productVersion) {
        Properties properties = new Properties();
        try {
            InputStream in = Tools.getResource(PROPERTY_FILE).openStream();
            properties.load(in);
            in.close();
        }
        catch (Exception e) {
            LogService.getGlobal().logError("Cannot read splash screen infos: " + e.getMessage());
        }
        properties.setProperty("version", productVersion);
        Plugin.initAboutTexts(properties);
        return properties;
    }

    private static Properties createProperties(String productName, String productVersion, String licensor, String url, String text, boolean renderTextNextToLogo) {
        Properties properties = new Properties();
        properties.setProperty("name", productName);
        properties.setProperty("version", productVersion);
        properties.setProperty("licensor", licensor);
        properties.setProperty("license", "URL: " + url);
        properties.setProperty("more", text);
        properties.setProperty("textNextToLogo", "" + renderTextNextToLogo);
        properties.setProperty("url", url);
        return properties;
    }

    static {
        backgroundImage = null;
        URL url = Tools.getResource(RAPID_MINER_LOGO_NAME);
        BufferedImage rmLogo = null;
        if (url != null) {
            try {
                rmLogo = ImageIO.read(url);
            }
            catch (IOException e) {
                LogService.getGlobal().logWarning("Cannot load logo for about box. Using empty image...");
            }
        }
        RAPID_MINER_LOGO = rmLogo;
        url = Tools.getResource("splashscreen_community.png");
        if (url != null) {
            try {
                backgroundImage = ImageIO.read(url);
            }
            catch (IOException e) {
                LogService.getGlobal().logWarning("Cannot load background for about box. Using empty image...");
            }
        }
    }

    private static class ContentPanel
    extends JPanel {
        private static final long serialVersionUID = -1763842074674706654L;
        private static final Paint MAIN_PAINT = Color.LIGHT_GRAY;
        private static final int MARGIN = 10;
        private Properties properties;
        private transient Image productLogo;

        public ContentPanel(Properties properties, Image productLogo) {
            this.properties = properties;
            this.productLogo = productLogo;
            int width = 450;
            int height = 350;
            if (backgroundImage != null) {
                width = backgroundImage.getWidth(this);
                height = backgroundImage.getHeight(this);
            }
            this.setPreferredSize(new Dimension(width, height));
            this.setMinimumSize(new Dimension(width, height));
            this.setMaximumSize(new Dimension(width, height));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.drawMain((Graphics2D)g);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        public void drawMain(Graphics2D g) {
            g.setPaint(MAIN_PAINT);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (backgroundImage != null) {
                g.drawImage(backgroundImage, 0, 0, this);
            }
            int nameY = 126;
            g.setFont(new Font("SansSerif", 1, 26));
            g.setColor(SwingTools.RAPID_I_BROWN);
            if (this.productLogo != null) {
                if ("true".equals(this.properties.getProperty("textNextToLogo"))) {
                    g.drawImage(this.productLogo, 20, 90, this);
                    g.drawString(this.properties.getProperty("name"), 20 + this.productLogo.getWidth(null) + 10, nameY);
                } else {
                    g.drawImage(this.productLogo, this.getWidth() / 2 - this.productLogo.getWidth(this) / 2, 90, this);
                }
            } else {
                g.drawString(this.properties.getProperty("name"), 20, nameY);
            }
            int y = 240;
            g.setColor(SwingTools.BROWN_FONT_COLOR);
            g.setFont(new Font("SansSerif", 1, 11));
            this.drawString(g, this.properties.getProperty("name") + " " + this.properties.getProperty("version"), y);
            y += 20;
            g.setFont(new Font("SansSerif", 0, 10));
            y = this.drawStringAndAdvance(g, this.properties.getProperty("name") + " " + this.properties.getProperty("version"), y);
            y = this.drawStringAndAdvance(g, this.properties.getProperty("copyright"), y);
            y = this.drawStringAndAdvance(g, this.properties.getProperty("licensor"), y);
            y = this.drawStringAndAdvance(g, this.properties.getProperty("license"), y);
            y = this.drawStringAndAdvance(g, this.properties.getProperty("warranty"), y);
            y = this.drawStringAndAdvance(g, this.properties.getProperty("more"), y);
        }

        private int drawStringAndAdvance(Graphics2D g, String string, int y) {
            if (string == null) {
                return y;
            }
            LinkedList<String> lines = new LinkedList<String>();
            String[] words = string.split("\\s+");
            String current = "";
            for (String word : words) {
                if (current.length() + word.length() < 80) {
                    current = current + word + " ";
                    continue;
                }
                lines.add(current);
                current = word + " ";
            }
            if (!current.isEmpty()) {
                lines.add(current);
            }
            for (String line : lines) {
                this.drawString(g, line, y);
                y += 15;
            }
            return y;
        }

        private void drawString(Graphics2D g, String text, int y) {
            if (text == null) {
                return;
            }
            float xPos = 10.0f;
            float yPos = y;
            g.drawString(text, xPos, yPos);
        }
    }
}

