/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.components;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.RMUrlHandler;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ToolTipWindow {
    private static final long serialVersionUID = 1L;
    private final JComponent parent;
    private final TipProvider tipProvider;
    private State state = State.IDLE;
    private Point lastPoint;
    private Point lastMousePosition;
    private Point mousePositionAtPopup;
    private Object currentId;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final ExtendedHTMLJEditorPane tipPane = new ExtendedHTMLJEditorPane("text/html", "<html></html>");
    private Component customComponent;
    private final JScrollPane tipScrollPane;
    private JDialog currentDialog;
    private final Timer showTipTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTipWindow.this.showTip();
        }
    });
    private final Action FOCUS_TIP_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTipWindow.this.focusTip();
        }
    };
    private final ResourceLabel f3Label;
    private final Dialog owner;
    private boolean mouseOnParentIsDown = false;

    public ToolTipWindow(TipProvider tipProvider, JComponent parent) {
        this(null, tipProvider, parent);
        this.tipPane.setToolTipText(null);
    }

    public ToolTipWindow(Dialog owner, TipProvider tipProvider, JComponent parent) {
        this.owner = owner;
        this.tipProvider = tipProvider;
        this.parent = parent;
        this.showTipTimer.setRepeats(false);
        this.tipPane.setFont(new Font("Sans-serif", 0, 9));
        this.tipPane.setMargin(new Insets(4, 4, 4, 4));
        this.tipPane.setEditable(false);
        this.tipPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e.getDescription().startsWith("loadMetaData?")) {
                        final String loc = e.getDescription().substring("loadMetaData?".length());
                        final Object idAtTimeOfDownload = ToolTipWindow.this.currentId;
                        ToolTipWindow.this.tipPane.setText("<p>Please stand by...</p>");
                        final AtomicBoolean tipWasClosed = new AtomicBoolean(false);
                        ToolTipWindow.this.currentDialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                tipWasClosed.set(true);
                            }
                        });
                        new ProgressThread("download_md_from_repository"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                this.getProgressListener().setTotal(100);
                                this.getProgressListener().setCompleted(10);
                                try {
                                    Entry entry = new RepositoryLocation(loc).locateEntry();
                                    if (entry instanceof IOObjectEntry) {
                                        ((IOObjectEntry)entry).retrieveMetaData();
                                    }
                                }
                                catch (Exception e) {
                                    SwingTools.showSimpleErrorMessage("error_downloading_metadata", (Throwable)e, loc, e.getMessage());
                                }
                                finally {
                                    this.getProgressListener().complete();
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!tipWasClosed.get()) {
                                            ToolTipWindow.this.refreshDialogContents(idAtTimeOfDownload);
                                            ToolTipWindow.this.autoAdjustDialogSize(ToolTipWindow.this.state == State.IN_FOCUS);
                                            ToolTipWindow.this.currentDialog.pack();
                                        }
                                    }
                                });
                            }
                        }.start();
                    } else {
                        RMUrlHandler.handleUrl(e.getDescription());
                    }
                }
            }
        });
        this.tipPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        StyleSheet css = ((HTMLEditorKit)this.tipPane.getEditorKit()).getStyleSheet();
        css.addRule("body {font-family:Sans;font-size:12pt}");
        css.addRule("h3 {margin:0; padding:0}");
        css.addRule("h4 {margin-bottom:0; margin-top:1ex; padding:0}");
        css.addRule("p  {margin-top:0; margin-bottom:1ex; padding:0}");
        css.addRule("ul {margin-top:0; margin-bottom:1ex; list-style-image: url(" + this.getClass().getResource("/com/rapidminer/resources/icons/modern/help/circle.png") + ")}");
        css.addRule("ul li {padding-bottom: 2px}");
        css.addRule("li.outPorts {padding-bottom: 0px}");
        css.addRule("ul li ul {margin-top:0; margin-bottom:1ex; list-style-image: url(" + this.getClass().getResource("/com/rapidminer/resources/icons/modern/help/line.png") + ")");
        css.addRule("li ul li {padding-bottom:0}");
        this.tipScrollPane = new JScrollPane(this.tipPane);
        this.tipScrollPane.setBorder(null);
        this.mainPanel.add((Component)this.tipScrollPane, "Center");
        this.f3Label = new ResourceLabel("F3_for_focus", new Object[0]);
        this.f3Label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(0, 4, 0, 0)));
        this.mainPanel.add((Component)this.f3Label, "South");
        int focusCondition = 0;
        parent.getInputMap(focusCondition).put(KeyStroke.getKeyStroke(114, 0), "focusTip");
        parent.getActionMap().put("focusTip", this.FOCUS_TIP_ACTION);
        this.mainPanel.getInputMap(focusCondition).put(KeyStroke.getKeyStroke(114, 0), "focusTip");
        this.mainPanel.getActionMap().put("focusTip", this.FOCUS_TIP_ACTION);
        this.tipPane.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "focusTip");
        this.mainPanel.getActionMap().put("focusTip", this.FOCUS_TIP_ACTION);
        parent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ToolTipWindow.this.mouseOnParentIsDown = true;
                ToolTipWindow.this.showTipTimer.stop();
                if (ToolTipWindow.this.state == State.SHOWING_TIP) {
                    ToolTipWindow.this.hideTip();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ToolTipWindow.this.mouseOnParentIsDown = false;
                if (ToolTipWindow.this.state == State.IDLE) {
                    ToolTipWindow.this.showTipTimer.start();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipWindow.this.mouseOnParentIsDown = false;
                ToolTipWindow.this.showTipTimer.stop();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipWindow.this.mouseOnParentIsDown = false;
                if (ToolTipWindow.this.state == State.IDLE) {
                    ToolTipWindow.this.showTipTimer.start();
                }
            }
        });
        parent.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ToolTipWindow.this.parentIsActive(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ToolTipWindow.this.parentIsActive(e);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)event;
                    if (me.getID() != 505 || ToolTipWindow.this.state != State.SHOWING_TIP || !SwingUtilities.isDescendingFrom(me.getComponent(), ToolTipWindow.this.currentDialog)) {
                        return;
                    }
                    Point origin = ToolTipWindow.this.currentDialog.getLocationOnScreen();
                    Point mep = me.getLocationOnScreen();
                    if (mep.getX() < origin.getX() || mep.getY() < origin.getY() || mep.getX() > origin.getX() + (double)ToolTipWindow.this.currentDialog.getWidth() || mep.getY() > origin.getY() + (double)ToolTipWindow.this.currentDialog.getHeight()) {
                        ToolTipWindow.this.hideTip();
                    }
                }
            }
        }, 48L);
    }

    private void parentIsActive(MouseEvent e) {
        this.lastMousePosition = e.getPoint();
        switch (this.state) {
            case IDLE: {
                if (this.mouseOnParentIsDown) break;
                this.showTipTimer.restart();
                break;
            }
            case SHOWING_TIP: {
                double dy;
                Object id = this.tipProvider.getIdUnder(e.getPoint());
                if (id == this.currentId) {
                    return;
                }
                double dx = (double)e.getX() - this.mousePositionAtPopup.getX();
                double dist = dx * dx + (dy = (double)e.getY() - this.mousePositionAtPopup.getY()) * dy;
                if (!(dist > 100.0)) break;
                this.hideTip();
                break;
            }
            case DISPOSED: {
                this.state = State.IDLE;
            }
        }
    }

    private void makeDialog(boolean undecorated, Point point) {
        this.currentDialog = new JDialog(this.owner != null ? this.owner : RapidMinerGUI.getMainFrame());
        if (undecorated) {
            this.currentDialog.setUndecorated(true);
            this.f3Label.setVisible(true);
            this.currentDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "focusTip");
            this.currentDialog.getRootPane().getActionMap().put("focusTip", this.FOCUS_TIP_ACTION);
        } else {
            this.f3Label.setVisible(false);
        }
        this.currentDialog.getRootPane().setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.currentDialog.getContentPane().setLayout(new BorderLayout());
        this.currentDialog.getContentPane().add(this.mainPanel);
        SwingTools.setDialogIcon(this.currentDialog);
        if (this.state == State.IN_FOCUS) {
            this.currentDialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    ToolTipWindow.this.hideTip();
                }
            });
        }
        this.currentDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (ToolTipWindow.this.state == State.SHOWING_TIP) {
                    ToolTipWindow.this.tipScrollPane.getVerticalScrollBar().setValue(0);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ToolTipWindow.this.state = State.IDLE;
            }
        });
        this.autoAdjustDialogSize(undecorated);
        this.currentDialog.pack();
        if (undecorated) {
            this.currentDialog.setLocation(new Point((int)(this.parent.getLocationOnScreen().getX() + point.getX()), (int)(this.parent.getLocationOnScreen().getY() + point.getY())));
        } else {
            Rectangle innerBounds = this.currentDialog.getComponent(0).getBounds();
            this.currentDialog.setLocation(new Point((int)(this.parent.getLocationOnScreen().getX() + point.getX() - (double)innerBounds.x), (int)(this.parent.getLocationOnScreen().getY() + point.getY() - (double)innerBounds.y)));
            int dx = this.currentDialog.getSize().width - this.tipScrollPane.getSize().width;
            int dy = this.currentDialog.getSize().height - this.tipScrollPane.getSize().height;
            this.currentDialog.setPreferredSize(new Dimension(this.tipScrollPane.getPreferredSize().width + dx, this.tipScrollPane.getPreferredSize().height + dy));
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = this.currentDialog.getBounds();
        if (bounds.getMaxX() > screenSize.getWidth()) {
            this.currentDialog.setLocation(new Point((int)(screenSize.getWidth() - bounds.getWidth()), (int)bounds.getY()));
            bounds = this.currentDialog.getBounds();
        }
        if (bounds.getMaxY() > screenSize.getHeight()) {
            this.currentDialog.setLocation(new Point((int)bounds.getX(), (int)(screenSize.getHeight() - bounds.getHeight())));
        }
        this.currentDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "CLOSE");
        this.currentDialog.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){
            private static final long serialVersionUID = 1373293026453738733L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipWindow.this.currentDialog.dispose();
            }
        });
        this.currentDialog.setVisible(true);
    }

    private void autoAdjustDialogSize(boolean undecorated) {
        int tipPaneHeight = (int)this.tipPane.getPreferredSize().getHeight();
        int tipPaneWidth = (int)this.tipPane.getPreferredSize().getWidth();
        if (tipPaneHeight > 300) {
            this.tipScrollPane.setPreferredSize(new Dimension(tipPaneWidth + 50, 300 + (undecorated ? 0 : this.f3Label.getHeight())));
        } else {
            this.tipScrollPane.setPreferredSize(new Dimension(tipPaneWidth + 50, tipPaneHeight + 30 + (undecorated ? 0 : this.f3Label.getHeight())));
        }
    }

    private void showTip() {
        if (this.state == State.IDLE) {
            if (!this.parent.isDisplayable()) {
                return;
            }
            Rectangle parentBounds = new Rectangle(this.parent.getLocationOnScreen(), new Dimension(this.parent.getWidth(), this.parent.getHeight()));
            if (!parentBounds.contains(MouseInfo.getPointerInfo().getLocation())) {
                return;
            }
            if (this.lastMousePosition == null) {
                return;
            }
            this.currentId = this.tipProvider.getIdUnder(this.lastMousePosition);
            if (this.currentId == null) {
                return;
            }
            this.refreshDialogContents(this.currentId);
            this.state = State.SHOWING_TIP;
            this.showTipTimer.stop();
            this.lastPoint = new Point((int)this.lastMousePosition.getX() - 50, (int)this.lastMousePosition.getY() + 10);
            this.mousePositionAtPopup = this.lastMousePosition;
            this.makeDialog(true, this.lastPoint);
            this.parent.requestFocus();
        } else {
            this.state = State.IDLE;
        }
    }

    private void focusTip() {
        if (this.state == State.SHOWING_TIP) {
            this.state = State.IN_FOCUS;
            this.currentDialog.dispose();
            this.currentDialog = null;
            this.makeDialog(false, this.lastPoint);
        }
    }

    private void hideTip() {
        if (this.currentDialog != null) {
            this.currentDialog.dispose();
            this.state = State.DISPOSED;
        }
    }

    private void refreshDialogContents(Object objectId) {
        String tipText = this.tipProvider.getTip(objectId);
        if (tipText == null || tipText.length() == 0) {
            return;
        }
        if (this.customComponent != null) {
            this.mainPanel.remove(this.customComponent);
        }
        this.mainPanel.remove(this.tipScrollPane);
        this.mainPanel.remove(this.tipPane);
        this.tipPane.setText("<html><body><div style=\"width:300px\">" + tipText + "</div></body></html>");
        if (this.customComponent != null) {
            this.mainPanel.remove(this.customComponent);
        }
        this.mainPanel.remove(this.tipPane);
        this.mainPanel.remove(this.tipScrollPane);
        this.customComponent = this.tipProvider.getCustomComponent(objectId);
        if (this.customComponent != null) {
            this.mainPanel.add((Component)this.tipPane, "North");
            this.mainPanel.add(this.customComponent, "Center");
        } else {
            this.tipScrollPane.setViewportView(this.tipPane);
            this.mainPanel.add((Component)this.tipScrollPane, "Center");
        }
    }

    private static enum State {
        IDLE,
        SHOWING_TIP,
        IN_FOCUS,
        DISPOSED;

    }

    public static interface TipProvider {
        public String getTip(Object var1);

        public Component getCustomComponent(Object var1);

        public Object getIdUnder(Point var1);
    }
}

