/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.components;

import com.rapidminer.gui.tools.ArrowButton;
import com.rapidminer.gui.tools.ViewToolBar;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class DropDownButton
extends JButton {
    private static final long serialVersionUID = -5987392204641149649L;
    private final PopupMenuListener popupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            DropDownButton.this.popupVisible = true;
            DropDownButton.this.mainButton.getModel().setRollover(true);
            DropDownButton.this.arrowButton.getModel().setSelected(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DropDownButton.this.popupVisible = false;
            DropDownButton.this.mainButton.getModel().setRollover(false);
            DropDownButton.this.arrowButton.getModel().setSelected(false);
            ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            DropDownButton.this.popupVisible = false;
        }
    };
    private final ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == DropDownButton.this.mainButton.getModel()) {
                if (DropDownButton.this.popupVisible && !DropDownButton.this.mainButton.getModel().isRollover()) {
                    DropDownButton.this.mainButton.getModel().setRollover(true);
                    return;
                }
                DropDownButton.this.arrowButton.getModel().setRollover(DropDownButton.this.mainButton.getModel().isRollover());
                DropDownButton.this.arrowButton.setSelected(DropDownButton.this.mainButton.getModel().isArmed() && DropDownButton.this.mainButton.getModel().isPressed());
            } else {
                if (DropDownButton.this.popupVisible && !DropDownButton.this.arrowButton.getModel().isSelected()) {
                    DropDownButton.this.arrowButton.getModel().setSelected(true);
                    return;
                }
                DropDownButton.this.mainButton.getModel().setRollover(DropDownButton.this.arrowButton.getModel().isRollover());
            }
        }
    };
    private JButton mainButton = this;
    private final ArrowButton arrowButton = new DropDownArrowButton();
    private boolean popupVisible = false;

    public DropDownButton(Action action) {
        super(action);
        this.mainButton.setText(null);
        this.mainButton.setOpaque(false);
        this.mainButton.setBorderPainted(false);
        this.mainButton.setMargin(new Insets(0, 0, 0, 0));
        this.mainButton.getModel().addChangeListener(this.changeListener);
        this.arrowButton.getModel().addChangeListener(this.changeListener);
        this.arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JPopupMenu popup = DropDownButton.this.getPopupMenu();
                popup.addPopupMenuListener(DropDownButton.this.popupMenuListener);
                popup.show(DropDownButton.this.mainButton, 0, DropDownButton.this.mainButton.getHeight());
            }
        });
        this.arrowButton.setMargin(new Insets(0, 0, 0, 0));
        this.mainButton.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DropDownButton.this.arrowButton.setEnabled(DropDownButton.this.mainButton.isEnabled());
            }
        });
    }

    protected abstract JPopupMenu getPopupMenu();

    public void add(Action action) {
        this.getPopupMenu().add(action);
    }

    public void add(JMenuItem item) {
        this.getPopupMenu().add(item);
    }

    public JButton addToToolBar(JToolBar toolbar) {
        toolbar.add(this.mainButton);
        toolbar.add(this.arrowButton);
        return this.mainButton;
    }

    public JButton addToToolBar(VLToolBar toolbar) {
        toolbar.add(this.mainButton);
        toolbar.add((JButton)this.arrowButton);
        return this.mainButton;
    }

    public JButton addToToolBar(ViewToolBar toolbar, int alignment) {
        toolbar.add((Component)this.mainButton, alignment);
        toolbar.add((Component)this.arrowButton, alignment);
        return this.mainButton;
    }

    public JButton addToFlowLayoutPanel(JPanel panel) {
        panel.add(this.mainButton);
        panel.add(this.arrowButton);
        return this.mainButton;
    }

    public static DropDownButton makeDropDownButton(Action mainAction, Action ... actions) {
        final JPopupMenu menu = new JPopupMenu();
        for (Action action : actions) {
            menu.add(action);
        }
        return new DropDownButton(mainAction){
            private static final long serialVersionUID = -7359018188605409766L;

            @Override
            protected JPopupMenu getPopupMenu() {
                return menu;
            }
        };
    }

    public static DropDownButton makeDropDownButton(Action action) {
        final JPopupMenu menu = new JPopupMenu();
        return new DropDownButton(action){
            private static final long serialVersionUID = -7359018188605409766L;

            @Override
            protected JPopupMenu getPopupMenu() {
                return menu;
            }
        };
    }

    public static class DropDownArrowButton
    extends ArrowButton {
        private static final long serialVersionUID = -398619111521186260L;

        public DropDownArrowButton() {
            super(5);
        }
    }
}

