/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.components;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.components.ColorIcon;
import com.rapidminer.gui.tools.components.ColorSelectionListener;
import com.rapidminer.tools.I18N;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorSelectionButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Color color;
    private AbstractColorChooserPanel[] colorChoosers = null;
    private List<ColorSelectionListener> listeners = new LinkedList<ColorSelectionListener>();

    public ColorSelectionButton(final String i18nKey, Color defaultColor, Object ... arguments) {
        this.color = defaultColor;
        this.setAction(new ResourceAction(i18nKey, arguments){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = ColorSelectionButton.this.showDialog(RapidMinerGUI.getMainFrame(), I18N.getGUILabel(i18nKey, new Object[0]), ColorSelectionButton.this.color);
                if (newColor != null) {
                    ColorSelectionButton.this.color = newColor;
                    ColorSelectionButton.this.setIcon(new ColorIcon(ColorSelectionButton.this.color));
                    ColorSelectionButton.this.notifyColorSelectionListeners(ColorSelectionButton.this.color);
                }
            }
        });
        this.setIcon(new ColorIcon(this.color));
    }

    public void addColorSelectionListener(ColorSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeColorSelectionListener(ColorSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyColorSelectionListeners(Color color) {
        for (ColorSelectionListener l : this.listeners) {
            l.colorSelected(color);
        }
    }

    public Color getSelectedColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setIcon(new ColorIcon(color));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setIcon(new ColorIcon(this.color));
        } else {
            ColorIcon colorIcon = new ColorIcon(new Color(235, 235, 235));
            colorIcon.setBorderColor(new Color(210, 210, 210));
            this.setIcon(colorIcon);
        }
    }

    public void setColorChooser(AbstractColorChooserPanel ... colorChoosers) {
        this.colorChoosers = colorChoosers;
    }

    private Color showDialog(Component component, String title, Color initialColor) throws HeadlessException {
        JColorChooser chooser = new JColorChooser(initialColor != null ? initialColor : Color.white);
        chooser.setPreviewPanel(new JPanel());
        if (this.colorChoosers != null) {
            chooser.setChooserPanels(this.colorChoosers);
        } else {
            chooser.removeChooserPanel(chooser.getChooserPanels()[0]);
            chooser.removeChooserPanel(chooser.getChooserPanels()[1]);
        }
        ColorTracker ok = new ColorTracker(chooser);
        JDialog dialog = JColorChooser.createDialog(component, title, true, chooser, ok, null);
        dialog.setVisible(true);
        return ok.getColor();
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 486260520128499950L;
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

