/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools.autocomplete;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AutoCompleteComboBoxAddition {
    private boolean allowAutoFill;
    private boolean caseSensitive;
    private final DocumentListener docListener;
    private final JComboBox comboBox;
    private final BasicComboBoxEditor comboBoxEditor;
    private static final long serialVersionUID = 1L;

    public AutoCompleteComboBoxAddition(JComboBox box) {
        this.comboBox = box;
        this.caseSensitive = false;
        this.allowAutoFill = false;
        this.comboBox.setEditable(true);
        this.comboBoxEditor = new AutoCompletionComboBoxEditor();
        this.comboBox.setEditor(this.comboBoxEditor);
        this.docListener = new AutoCompletionDocumentListener();
        ((JTextField)this.comboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.docListener);
        for (Component c : this.comboBox.getComponents()) {
            c.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    AutoCompleteComboBoxAddition.this.allowAutoFill = true;
                }

                @Override
                public void focusLost(FocusEvent e) {
                    AutoCompleteComboBoxAddition.this.allowAutoFill = false;
                    JTextField editorComponent = (JTextField)AutoCompleteComboBoxAddition.this.comboBox.getEditor().getEditorComponent();
                    editorComponent.setCaretPosition(editorComponent.getCaretPosition());
                }
            });
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private String checkForMatch(String givenString, Collection<String> collectionOfStrings, boolean caseSensitive) {
        if (givenString == null || collectionOfStrings == null) {
            return null;
        }
        String returnString = null;
        Collections.sort(new ArrayList<String>(collectionOfStrings));
        for (String vectorString : collectionOfStrings) {
            if (vectorString == null) continue;
            if (caseSensitive) {
                if (!vectorString.startsWith(givenString)) continue;
                returnString = vectorString;
                break;
            }
            if (!vectorString.toLowerCase(Locale.ENGLISH).startsWith(givenString.toLowerCase(Locale.ENGLISH))) continue;
            returnString = vectorString;
            break;
        }
        return returnString;
    }

    private final class AutoCompletionComboBoxEditor
    extends BasicComboBoxEditor {
        private AutoCompletionComboBoxEditor() {
        }

        @Override
        public void setItem(Object anObject) {
            ((JTextField)this.getEditorComponent()).getDocument().removeDocumentListener(AutoCompleteComboBoxAddition.this.docListener);
            super.setItem(anObject);
            ((JTextField)this.getEditorComponent()).getDocument().addDocumentListener(AutoCompleteComboBoxAddition.this.docListener);
        }
    }

    private final class AutoCompletionDocumentListener
    implements DocumentListener {
        private AutoCompletionDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                if (!AutoCompleteComboBoxAddition.this.allowAutoFill) {
                    return;
                }
                Vector<String> vectorOfStrings = new Vector<String>();
                for (int i = 0; i < AutoCompleteComboBoxAddition.this.comboBox.getModel().getSize(); ++i) {
                    vectorOfStrings.add(String.valueOf(AutoCompleteComboBoxAddition.this.comboBox.getModel().getElementAt(i)));
                }
                Document document = e.getDocument();
                String documentText = document.getText(0, document.getLength());
                String result = AutoCompleteComboBoxAddition.this.checkForMatch(documentText, vectorOfStrings, AutoCompleteComboBoxAddition.this.caseSensitive);
                final String newString = result == null ? documentText : result;
                final int startSelect = document.getLength();
                final int endSelect = newString.length();
                final JTextField editorComponent = (JTextField)AutoCompleteComboBoxAddition.this.comboBox.getEditor().getEditorComponent();
                if (startSelect == e.getOffset() + e.getLength()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoCompleteComboBoxAddition.this.comboBox.getModel().setSelectedItem(newString);
                            editorComponent.getDocument().removeDocumentListener(AutoCompleteComboBoxAddition.this.docListener);
                            editorComponent.setText(newString);
                            editorComponent.getDocument().addDocumentListener(AutoCompleteComboBoxAddition.this.docListener);
                            editorComponent.setCaretPosition(startSelect);
                            editorComponent.setSelectionStart(startSelect);
                            editorComponent.setSelectionEnd(endSelect);
                        }
                    });
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

