/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.OpenAction;
import com.rapidminer.gui.actions.WelcomeNewAction;
import com.rapidminer.gui.actions.WelcomeOpenAction;
import com.rapidminer.gui.actions.WelcomeOpenRecentAction;
import com.rapidminer.gui.actions.WelcomeTutorialAction;
import com.rapidminer.gui.actions.WelcomeWizardAction;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ImagePanel;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RMUrlHandler;
import com.rapidminer.tools.Tools;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class WelcomeScreen
extends JPanel
implements Dockable {
    private static Image borderTopImage = null;
    private static Image borderBottomImage = null;
    private static Image bottomImage = null;
    private static final long serialVersionUID = -6916236648023490473L;
    protected static final String PROXY_HELP = "<p>We urgently recommend to provide proxy settings since they affect the functionality of RapidMiner in various ways. Amongst others, Internet connectivity is required for</p><ul><li>updating RapidMiner via the Update Server,</li><li>installing numerous RapidMiner extensions,</li><li>Web crawling and Web content mining (RapidMiner Web Extension),</li><li>sharing processes via the RapidMiner Community Extension,</li><li>accessing remote repositories,</li><li>getting online help, and</li><li>displaying the RapidMiner news page.</li></ul><p>Specifying the respective settings in the preferences takes effect immediately without restarting RapidMiner.</p>";
    private final JList recentFileList;
    private final MainFrame mainFrame;
    public static final String WELCOME_SCREEN_DOCK_KEY = "welcome";
    private final DockKey DOCK_KEY = new ResourceDockKey("welcome");

    public WelcomeScreen(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        ImagePanel borderTopPanel = new ImagePanel(borderTopImage, 2);
        this.add((Component)borderTopPanel, c);
        ExtendedJToolBar actionBar = new ExtendedJToolBar();
        actionBar.setBorder(null);
        actionBar.setLayout(new FlowLayout(1));
        actionBar.setBackground(Color.WHITE);
        actionBar.setBorderPainted(false);
        JButton button = new JButton(new WelcomeNewAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeOpenRecentAction(this));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        if (RapidMinerGUI.getRecentFiles().size() == 0) {
            button.setEnabled(false);
        }
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeOpenAction());
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeWizardAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        actionBar.addSeparator();
        actionBar.addSeparator();
        button = new JButton(new WelcomeTutorialAction(this.mainFrame));
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        actionBar.add(button);
        this.add((Component)actionBar, c);
        this.recentFileList = new JList<Object>(RapidMinerGUI.getRecentFiles().toArray(new Object[RapidMinerGUI.getRecentFiles().size()]));
        this.recentFileList.setBorder(BorderFactory.createBevelBorder(1));
        this.recentFileList.setSelectionMode(0);
        this.recentFileList.setBorder(ButtonDialog.createTitledBorder("Recent Processes"));
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    WelcomeScreen.this.mainFrame.getPerspectives().showPerspective("design");
                    WelcomeScreen.this.openRecentProcess();
                }
            }
        };
        this.recentFileList.addMouseListener(mouseListener);
        JPanel listPanel = new JPanel(new FlowLayout(1));
        listPanel.add(this.recentFileList);
        listPanel.setBackground(Color.WHITE);
        this.add((Component)listPanel, c);
        ImagePanel borderBottomPanel = new ImagePanel(borderBottomImage, 2);
        this.add((Component)borderBottomPanel, c);
        ImagePanel bottomTextPanel = new ImagePanel(bottomImage, 0);
        BoxLayout textLayout = new BoxLayout(bottomTextPanel, 0);
        bottomTextPanel.setLayout(textLayout);
        final ExtendedHTMLJEditorPane newsPane = new ExtendedHTMLJEditorPane("text/html", "<html><body><h1>RapidMiner News</h1><p>Downloading news. If news don't show up, check your Internet connection and proxy settings in the <a href=\"rm://preferences\">Preferences</a> under \"System\".<p>We urgently recommend to provide proxy settings since they affect the functionality of RapidMiner in various ways. Amongst others, Internet connectivity is required for</p><ul><li>updating RapidMiner via the Update Server,</li><li>installing numerous RapidMiner extensions,</li><li>Web crawling and Web content mining (RapidMiner Web Extension),</li><li>sharing processes via the RapidMiner Community Extension,</li><li>accessing remote repositories,</li><li>getting online help, and</li><li>displaying the RapidMiner news page.</li></ul><p>Specifying the respective settings in the preferences takes effect immediately without restarting RapidMiner.</p></body></html>");
        newsPane.installDefaultStylesheet();
        new Thread("Load News"){

            @Override
            public void run() {
                try {
                    newsPane.setPage(new URL("http://news.rapidminer.com/"));
                }
                catch (IOException e2) {
                    LogService.getRoot().log(Level.INFO, "Cannot download news: " + e2, e2);
                    newsPane.setText("<html><body><h1>RapidMiner News</h1><p>Cannot download news. Internet connection may be down. If your Internet connection is up, please check your proxy settings in the <a href=\"rm://preferences\">preferences</a> under \"System\".<p>We urgently recommend to provide proxy settings since they affect the functionality of RapidMiner in various ways. Amongst others, Internet connectivity is required for</p><ul><li>updating RapidMiner via the Update Server,</li><li>installing numerous RapidMiner extensions,</li><li>Web crawling and Web content mining (RapidMiner Web Extension),</li><li>sharing processes via the RapidMiner Community Extension,</li><li>accessing remote repositories,</li><li>getting online help, and</li><li>displaying the RapidMiner news page.</li></ul><p>Specifying the respective settings in the preferences takes effect immediately without restarting RapidMiner.</p></body></html>");
                }
            }
        }.start();
        newsPane.setOpaque(false);
        newsPane.setEditable(false);
        newsPane.setPreferredSize(new Dimension(300, 180));
        JScrollPane newsScrollPane = new JScrollPane(newsPane);
        newsScrollPane.setPreferredSize(new Dimension(300, 180));
        newsScrollPane.setOpaque(false);
        newsScrollPane.getViewport().setOpaque(false);
        newsScrollPane.setBorder(null);
        bottomTextPanel.add(newsScrollPane);
        newsPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && !RMUrlHandler.handleUrl(e.getDescription())) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception e1) {
                        LogService.getRoot().log(Level.WARNING, "Cannot display news site " + e.getDescription() + " (" + e1.getMessage() + "). Network may be down.", e1);
                    }
                }
            }
        });
        c.weighty = 1.0;
        layout.setConstraints(bottomTextPanel, c);
        this.add(bottomTextPanel);
    }

    public void openRecentProcess() {
        int selectedIndex = this.recentFileList.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (RapidMinerGUI.getRecentFiles().size() > 0) {
            OpenAction.open(RapidMinerGUI.getRecentFiles().get(selectedIndex), true);
        } else {
            OpenAction.open();
        }
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    static {
        try {
            URL url = Tools.getResource("welcome_border_top.png");
            if (url != null) {
                borderTopImage = ImageIO.read(url);
            }
            if ((url = Tools.getResource("welcome_border_bottom.png")) != null) {
                borderBottomImage = ImageIO.read(url);
            }
            if ((url = Tools.getResource("welcome_bottom.png")) != null) {
                bottomImage = ImageIO.read(url);
            }
        }
        catch (IOException e) {
            LogService.getRoot().warning("Cannot load images for welcome screen. Using empty welcome screen...");
        }
    }
}

