/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ViewToolBar
extends JToolBar {
    private static final long serialVersionUID = -9219638829666999431L;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 1;
    private JToolBar leftToolBar = new JToolBar();
    private JToolBar rightToolBar = new JToolBar();

    public ViewToolBar() {
        this(0);
    }

    public ViewToolBar(int orientation) {
        this.setFloatable(false);
        this.setRollover(true);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.setLayout(new BorderLayout());
        this.leftToolBar.setFloatable(false);
        this.leftToolBar.setRollover(true);
        this.leftToolBar.setBorder(null);
        this.rightToolBar.setFloatable(false);
        this.rightToolBar.setRollover(true);
        this.rightToolBar.setBorder(null);
        this.leftToolBar.setOrientation(orientation);
        this.rightToolBar.setOrientation(orientation);
        if (orientation == 0) {
            this.add((Component)this.leftToolBar, "West");
            this.add((Component)this.rightToolBar, "East");
        } else {
            this.add((Component)this.leftToolBar, "North");
            this.add((Component)this.rightToolBar, "South");
            this.setBorder(null);
        }
    }

    @Override
    public Component add(Component c) {
        return this.add(c, 0);
    }

    @Override
    public Component add(Component c, int alignment) {
        switch (alignment) {
            case 0: {
                this.leftToolBar.add(c);
                break;
            }
            case 1: {
                this.rightToolBar.add(c);
                break;
            }
            default: {
                this.leftToolBar.add(c);
            }
        }
        return c;
    }

    public void addSeparator(int alignment) {
        switch (alignment) {
            case 0: {
                this.leftToolBar.addSeparator();
                break;
            }
            case 1: {
                this.rightToolBar.addSeparator();
                break;
            }
            default: {
                this.leftToolBar.addSeparator();
            }
        }
    }

    @Override
    public JButton add(Action a) {
        return this.add(a, 0);
    }

    public JButton add(Action a, int alignment) {
        switch (alignment) {
            case 0: {
                return this.leftToolBar.add(a);
            }
            case 1: {
                return this.rightToolBar.add(a);
            }
        }
        return this.leftToolBar.add(a);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.leftToolBar != null) {
            this.leftToolBar.setBackground(bg);
        }
        if (this.rightToolBar != null) {
            this.rightToolBar.setBackground(bg);
        }
    }
}

