/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

public class VersionNumber
implements Comparable<VersionNumber> {
    private int majorNumber;
    private int minorNumber;
    private int patchLevel;
    private boolean alpha;
    private int alphaNumber;
    private boolean beta;
    private int betaNumber;

    public VersionNumber(String versionString) {
        String version = versionString.toLowerCase().trim();
        int alphaIndex = version.indexOf("alpha");
        if (alphaIndex >= 0) {
            String[] numbers = version.substring(0, alphaIndex).split("\\.");
            if (numbers.length > 0) {
                this.majorNumber = Integer.parseInt(numbers[0]);
            }
            if (numbers.length > 1) {
                this.minorNumber = Integer.parseInt(numbers[1]);
            }
            if (numbers.length > 2) {
                this.patchLevel = Integer.parseInt(numbers[2]);
            }
            this.alpha = true;
            String alphaNumberString = version.substring(alphaIndex + "alpha".length());
            if (alphaNumberString.length() > 0) {
                this.alphaNumber = Integer.parseInt(alphaNumberString);
            }
        } else {
            int betaIndex = version.indexOf("beta");
            if (betaIndex >= 0) {
                String[] numbers = version.substring(0, betaIndex).split("\\.");
                if (numbers.length > 0) {
                    this.majorNumber = Integer.parseInt(numbers[0]);
                }
                if (numbers.length > 1) {
                    this.minorNumber = Integer.parseInt(numbers[1]);
                }
                if (numbers.length > 2) {
                    this.patchLevel = Integer.parseInt(numbers[2]);
                }
                this.beta = true;
                String betaNumberString = version.substring(betaIndex + "beta".length());
                if (betaNumberString.length() > 0) {
                    this.betaNumber = Integer.parseInt(betaNumberString);
                }
            } else {
                String[] numbers = version.split("\\.");
                if (numbers.length > 0) {
                    this.majorNumber = Integer.parseInt(numbers[0]);
                }
                if (numbers.length > 1) {
                    this.minorNumber = Integer.parseInt(numbers[1]);
                }
                if (numbers.length > 2) {
                    this.patchLevel = Integer.parseInt(numbers[2]);
                }
            }
        }
    }

    public VersionNumber(int majorNumber, int minorNumber) {
        this(majorNumber, minorNumber, 0, false, 0, false, 0);
    }

    public VersionNumber(int majorNumber, int minorNumber, int patchLevel) {
        this(majorNumber, minorNumber, patchLevel, false, 0, false, 0);
    }

    public VersionNumber(int majorNumber, int minorNumber, int patchLevel, boolean alpha, int alphaNumber, boolean beta, int betaNumber) {
        this.majorNumber = majorNumber;
        this.minorNumber = minorNumber;
        this.patchLevel = patchLevel;
        this.alpha = alpha;
        this.alphaNumber = alphaNumber;
        this.beta = beta;
        this.betaNumber = betaNumber;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        VersionNumber other = (VersionNumber)o;
        return this.majorNumber == other.majorNumber && this.minorNumber == other.minorNumber && this.patchLevel == other.patchLevel && this.alpha == other.alpha && this.alphaNumber == other.alphaNumber && this.beta == other.beta && this.betaNumber == other.betaNumber;
    }

    public int hashCode() {
        return Double.valueOf(this.majorNumber).hashCode() ^ Double.valueOf(this.minorNumber).hashCode() ^ Double.valueOf(this.patchLevel).hashCode() ^ Boolean.valueOf(this.alpha).hashCode() ^ Double.valueOf(this.alphaNumber).hashCode() ^ Boolean.valueOf(this.beta).hashCode() ^ Double.valueOf(this.betaNumber).hashCode();
    }

    public boolean isAtLeast(int major, int minor, int buildNumber) {
        return this.compareTo(new VersionNumber(major, minor, buildNumber)) >= 0;
    }

    public boolean isAtLeast(VersionNumber other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isAtMost(int major, int minor, int buildNumber) {
        return this.compareTo(new VersionNumber(major, minor, buildNumber)) <= 0;
    }

    public boolean isAtMost(VersionNumber other) {
        return this.compareTo(other) <= 0;
    }

    @Override
    public int compareTo(VersionNumber o) {
        int index = Double.compare(this.majorNumber, o.majorNumber);
        if (index != 0) {
            return index;
        }
        index = Double.compare(this.minorNumber, o.minorNumber);
        if (index != 0) {
            return index;
        }
        index = Double.compare(this.patchLevel, o.patchLevel);
        if (index != 0) {
            return index;
        }
        if (this.alpha) {
            if (o.alpha) {
                return Double.compare(this.alphaNumber, o.alphaNumber);
            }
            return -1;
        }
        if (this.beta) {
            if (o.alpha) {
                return 1;
            }
            if (o.beta) {
                return Double.compare(this.betaNumber, o.betaNumber);
            }
            return -1;
        }
        if (o.alpha) {
            return 1;
        }
        if (o.beta) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String alphaBetaString = "";
        if (this.alpha) {
            alphaBetaString = "alpha" + (this.alphaNumber >= 2 ? Integer.valueOf(this.alphaNumber) : "");
        } else if (this.beta) {
            alphaBetaString = "beta" + (this.betaNumber >= 2 ? Integer.valueOf(this.betaNumber) : "");
        }
        return this.majorNumber + "." + this.minorNumber + "." + "000".substring((this.patchLevel + "").length()) + this.patchLevel + alphaBetaString;
    }

    public String getLongVersion() {
        return this.toString();
    }

    public String getShortVersion() {
        return this.majorNumber + "." + this.minorNumber;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }
}

