/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.tools.LogService;
import java.util.logging.Level;

public class UpdateQueue
extends Thread {
    private Runnable pending;
    private Object lock = new Object();
    private boolean shutdownRequested = false;

    public UpdateQueue(String name) {
        super("UpdateQueue-" + name);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.pending = runnable;
            this.lock.notifyAll();
        }
    }

    public void executeBackgroundJob(final ProgressThread progressThread) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                progressThread.startAndWait();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdownRequested) {
            Runnable target;
            Object object = this.lock;
            synchronized (object) {
                target = this.pending;
                this.pending = null;
            }
            if (target != null) {
                try {
                    target.run();
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Error executing task in " + this.getName() + ": " + e, e);
                }
            }
            object = this.lock;
            synchronized (object) {
                if (this.pending == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.pending = null;
            this.shutdownRequested = true;
            this.lock.notifyAll();
        }
    }
}

