/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class TextPanel
extends JPanel {
    private static final long serialVersionUID = -5728947680003081065L;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_TOP = 0;
    public static final int ALIGNMENT_BOTTOM = 1;
    protected static final Font TITLE_FONT = new Font("SansSerif", 1, 12);
    protected static final Font TEXT_FONT = new Font("SansSerif", 0, 11);
    protected static final int LINE_HEIGHT = 16;
    protected static final int MARGIN = 24;
    protected static final int TITLE_MARGIN = 5;
    private String title;
    private String[] textLines;
    private int height;
    private int width;
    private int xAlignment = 1;
    private int yAlignment = 0;
    private boolean resized = false;

    public TextPanel(String title, String[] textLines, int xAlignment, int yAlignment) {
        this.title = title;
        this.xAlignment = xAlignment;
        this.yAlignment = yAlignment;
        this.setText(textLines);
        this.setOpaque(false);
    }

    public void setText(String[] textLines) {
        this.textLines = textLines;
        this.height = 21 + textLines.length * 16 + 24;
        this.resized = false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        this.width = 1;
        g.setColor(SwingTools.BROWN_FONT_COLOR);
        g.setFont(TITLE_FONT);
        int yPos = this.getTextStartY();
        this.drawString(g, this.title, yPos);
        Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(this.title, g);
        this.width = (int)Math.max((double)this.width, stringBounds.getWidth());
        yPos += 5;
        g.setFont(TEXT_FONT);
        for (String line : this.textLines) {
            this.drawString(g, line, yPos += 16);
            stringBounds = g.getFontMetrics().getStringBounds(line, g);
            this.width = (int)Math.max((double)this.width, stringBounds.getWidth());
        }
        this.width += 48;
        Dimension dimension = new Dimension(this.width, this.height);
        this.setPreferredSize(dimension);
        if (!this.resized) {
            this.revalidate();
            this.repaint();
            this.resized = true;
        }
    }

    private void drawString(Graphics2D g, String text, int height) {
        switch (this.xAlignment) {
            case 0: {
                float xPos = 24.0f;
                float yPos = height;
                g.drawString(text, xPos, yPos);
                break;
            }
            case 1: {
                Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(text, g);
                float xPos = (float)((double)(this.getWidth() - 24) - stringBounds.getWidth());
                float yPos = height;
                g.drawString(text, xPos, yPos);
            }
        }
    }

    protected int getTextStartY() {
        int yPos = 24;
        switch (this.yAlignment) {
            case 0: {
                yPos = 24;
                break;
            }
            case 1: {
                yPos = this.getHeight() - this.textLines.length * 16 - 24;
            }
        }
        return yPos;
    }
}

