/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.Tools;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SystemMonitor
extends JPanel
implements Dockable {
    private static final long serialVersionUID = -6860624220979494451L;
    private static final Color BACKGROUND = Color.WHITE;
    private static final Color TEXT_COLOR = SwingTools.VERY_DARK_BLUE;
    private static final Color MEMORY_COLOR = SwingTools.LIGHTEST_BLUE;
    private static final Color GRID_COLOR = Color.LIGHT_GRAY;
    private static final Color LINE_COLOR = SwingTools.VERY_DARK_BLUE;
    private static final int NUMBER_OF_MEASUREMENTS = 20;
    private static final int GRID_X = 10;
    private static final int GRID_Y = 10;
    private static final int MARGIN = 10;
    private static final int DELAY = 1000;
    private final long[] memory = new long[20];
    private int currentMeasurement = 0;
    private double currentlyUsed = 0.0;
    private Color backgroundColor = BACKGROUND;
    private Color textColor = TEXT_COLOR;
    private Color memoryColor = MEMORY_COLOR;
    private Color gridColor = GRID_COLOR;
    private Color lineColor = LINE_COLOR;
    public static final String SYSTEM_MONITOR_DOCK_KEY = "system_monitor";
    private final DockKey DOCK_KEY = new ResourceDockKey("system_monitor");

    public SystemMonitor() {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.setBackground(this.backgroundColor);
    }

    public void startMonitorThread() {
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemMonitor.this.currentlyUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                ((SystemMonitor)SystemMonitor.this).memory[((SystemMonitor)SystemMonitor.this).currentMeasurement] = (long)SystemMonitor.this.currentlyUsed;
                SystemMonitor.this.currentMeasurement = (SystemMonitor.this.currentMeasurement + 1) % SystemMonitor.this.memory.length;
                SystemMonitor.this.repaint();
            }
        }).start();
    }

    protected final void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.setBackground(this.backgroundColor);
    }

    protected final void setTextColor(Color color) {
        this.textColor = color;
    }

    protected final void setMemoryColor(Color color) {
        this.memoryColor = color;
    }

    protected final void setGridColor(Color color) {
        this.gridColor = color;
    }

    protected final void setLineColor(Color color) {
        this.lineColor = color;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        GeneralPath path = new GeneralPath();
        Dimension d = this.getSize();
        int monitorWidth = (int)d.getWidth() - 20;
        int monitorHeight = (int)d.getHeight() - 20;
        long total = Runtime.getRuntime().totalMemory();
        path.moveTo(10.0f, 10 + monitorHeight);
        for (int i = 0; i < this.memory.length; ++i) {
            int index = (this.currentMeasurement + i) % this.memory.length;
            path.lineTo(10 + i * monitorWidth / (this.memory.length - 1), (long)(10 + monitorHeight) - (long)monitorHeight * this.memory[index] / total);
        }
        path.lineTo(10 + monitorWidth, 10 + monitorHeight);
        path.closePath();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.gridColor);
        for (int x = 0; x < 11; ++x) {
            g2d.drawLine(10 + x * monitorWidth / 10, 10, 10 + x * monitorWidth / 10, 10 + monitorHeight);
        }
        for (int y = 0; y < 11; ++y) {
            g2d.drawLine(10, 10 + y * monitorHeight / 10, 10 + monitorWidth, 10 + y * monitorHeight / 10);
        }
        Color currentMemoryColor = this.memoryColor;
        if (this.currentlyUsed > 0.2 * (double)Runtime.getRuntime().maxMemory()) {
            double more = this.currentlyUsed - 0.2 * (double)Runtime.getRuntime().maxMemory();
            double factor = more / (0.6 * (double)Runtime.getRuntime().maxMemory());
            currentMemoryColor = this.getMemoryColor(Math.max(Math.min(1.0, factor), 0.0));
        }
        g2d.setColor(currentMemoryColor);
        g2d.fill(path);
        g2d.setColor(this.lineColor);
        g2d.draw(path);
        g2d.setColor(this.textColor);
        Font font = new Font("Courier", 0, 11);
        g2d.setFont(font);
        String totalString = " Total: " + Tools.formatSizeInBytes(total);
        String maxString = " Max:   " + Tools.formatSizeInBytes(Runtime.getRuntime().maxMemory());
        Rectangle2D totalBounds = g2d.getFontMetrics().getStringBounds(totalString, g2d);
        Rectangle2D maxBounds = g2d.getFontMetrics().getStringBounds(totalString, g2d);
        int totalHeight = 4 * font.getSize() + 20;
        int totalWidth = (int)Math.max(totalBounds.getWidth(), maxBounds.getWidth()) + 30;
        if (totalHeight < this.getHeight() && totalWidth < this.getWidth()) {
            g2d.drawString(totalString, 10, 10 + (monitorHeight - font.getSize()));
            g2d.drawString(maxString, 10, 10 + (monitorHeight - 2 * font.getSize()));
        }
    }

    private Color getMemoryColor(double value) {
        if (Double.isNaN(value)) {
            return SwingTools.LIGHTEST_BLUE;
        }
        float[] minCol = Color.RGBtoHSB(SwingTools.LIGHTEST_BLUE.getRed(), SwingTools.LIGHTEST_BLUE.getGreen(), SwingTools.LIGHTEST_BLUE.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(SwingTools.LIGHTEST_RED.getRed(), SwingTools.LIGHTEST_RED.getGreen(), SwingTools.LIGHTEST_RED.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        return new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

