/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.look.fc.Bookmark;
import com.rapidminer.gui.look.fc.BookmarkIO;
import com.rapidminer.gui.tools.DefaultFrameIconProvider;
import com.rapidminer.gui.tools.ExtendedJFileChooser;
import com.rapidminer.gui.tools.FrameIconProvider;
import com.rapidminer.gui.tools.SimpleFileFilter;
import com.rapidminer.gui.tools.dialogs.ConfirmDialog;
import com.rapidminer.gui.tools.dialogs.ErrorDialog;
import com.rapidminer.gui.tools.dialogs.ExtendedErrorDialog;
import com.rapidminer.gui.tools.dialogs.InputDialog;
import com.rapidminer.gui.tools.dialogs.LongMessageDialog;
import com.rapidminer.gui.tools.dialogs.MessageDialog;
import com.rapidminer.gui.tools.dialogs.ResultViewDialog;
import com.rapidminer.gui.tools.dialogs.SelectionInputDialog;
import com.rapidminer.gui.tools.syntax.SyntaxStyle;
import com.rapidminer.gui.tools.syntax.SyntaxUtilities;
import com.rapidminer.gui.tools.syntax.TextAreaDefaults;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class SwingTools {
    private static final int TOOL_TIP_LINE_LENGTH = 100;
    public static final int TABLE_ROW_EXTRA_HEIGHT = 4;
    public static final int TABLE_WITH_COMPONENTS_ROW_EXTRA_HEIGHT = 10;
    public static final Color DARKEST_YELLOW = new Color(250, 219, 172);
    public static final Color DARK_YELLOW = new Color(250, 226, 190);
    public static final Color LIGHT_YELLOW = new Color(250, 233, 207);
    public static final Color LIGHTEST_YELLOW = new Color(250, 240, 225);
    public static final Color TRANSPARENT_YELLOW = new Color(255, 245, 230, 190);
    public static final Color VERY_DARK_BLUE = new Color(172, 172, 212);
    public static final Color DARKEST_BLUE = new Color(182, 202, 242);
    public static final Color DARK_BLUE = new Color(199, 213, 242);
    public static final Color LIGHT_BLUE = new Color(216, 224, 242);
    public static final Color LIGHTEST_BLUE = new Color(233, 236, 242);
    public static final Color RAPID_I_ORANGE = new Color(242, 146, 0);
    public static final Color RAPID_I_BROWN = new Color(97, 66, 11);
    public static final Color RAPID_I_BEIGE = new Color(202, 188, 165);
    public static final Color LIGHTEST_RED = new Color(250, 210, 210);
    public static final Color BROWN_FONT_COLOR = new Color(63, 53, 24);
    public static final Color LIGHT_BROWN_FONT_COLOR = new Color(113, 103, 74);
    private static Set<String> iconPaths = new LinkedHashSet<String>(Collections.singleton("icons/"));
    private static List<Image> allFrameIcons = new LinkedList<Image>();
    private static FrameIconProvider frameIconProvider;
    private static final String DEFAULT_FRAME_ICON_BASE_NAME = "rapidminer_frame_icon_";
    private static final Map<String, ImageIcon> ICON_CACHE;
    private static final Object ICON_LOCK;

    public static void setFrameIconProvider(FrameIconProvider _frameIconProvider) {
        frameIconProvider = _frameIconProvider;
        SwingTools.reloadFrameIcons();
    }

    public static void setupFrameIcons(String frameIconBaseName) {
        SwingTools.setFrameIconProvider(new DefaultFrameIconProvider(frameIconBaseName));
        SwingTools.reloadFrameIcons();
    }

    private static void reloadFrameIcons() {
        allFrameIcons = frameIconProvider == null ? new LinkedList<Image>() : frameIconProvider.getFrameIcons();
    }

    public static List<Image> getFrameIconList() {
        return allFrameIcons;
    }

    public static void setFrameIcon(JFrame frame) {
        Method iconImageMethod = null;
        try {
            iconImageMethod = frame.getClass().getMethod("setIconImages", List.class);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (iconImageMethod != null) {
            try {
                iconImageMethod.invoke((Object)frame, allFrameIcons);
            }
            catch (Throwable e) {
                if (allFrameIcons.size() > 0) {
                    frame.setIconImage(allFrameIcons.get(0));
                }
            }
        } else if (allFrameIcons.size() > 0) {
            frame.setIconImage(allFrameIcons.get(0));
        }
    }

    public static void setDialogIcon(JDialog dialog) {
        Method iconImageMethod = null;
        try {
            iconImageMethod = dialog.getClass().getMethod("setIconImages", List.class);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (iconImageMethod != null) {
            try {
                iconImageMethod.invoke((Object)dialog, allFrameIcons);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static GradientPaint makeRedPaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, new Color(200, 50, 50), (float)width / 2.0f, (float)height / 2.0f, new Color(255, 100, 100), true);
    }

    public static GradientPaint makeBluePaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, LIGHT_BLUE, (float)width / 2.0f, (float)height / 2.0f, LIGHTEST_BLUE, true);
    }

    public static GradientPaint makeYellowPaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, LIGHT_YELLOW, (float)width / 2.0f, (float)height / 2.0f, LIGHTEST_YELLOW, true);
    }

    public static ImageIcon createIcon(String iconName) {
        if (RapidMiner.getExecutionMode().isHeadless()) {
            return null;
        }
        for (String path : iconPaths) {
            ImageIcon icon = SwingTools.createImage(path + iconName);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public static String getIconPath(String iconName) {
        if (RapidMiner.getExecutionMode().isHeadless()) {
            return null;
        }
        for (String path : iconPaths) {
            ImageIcon icon = SwingTools.createImage(path + iconName);
            if (icon == null) continue;
            return Tools.getResource(path + iconName).toString();
        }
        return null;
    }

    public static void addIconStoragePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        iconPaths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon createImage(String imageName) {
        if (RapidMiner.getExecutionMode().isHeadless()) {
            return null;
        }
        Object object = ICON_LOCK;
        synchronized (object) {
            if (ICON_CACHE.containsKey(imageName)) {
                return ICON_CACHE.get(imageName);
            }
            URL url = Tools.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                ICON_CACHE.put(imageName, icon);
                return icon;
            }
            LogService.getRoot().fine("Cannot load image '" + imageName + "': icon will not be displayed");
            return null;
        }
    }

    public static void loadIcons() {
        ResourceBundle guiBundle = I18N.getGUIBundle();
        Enumeration<String> e = guiBundle.getKeys();
        while (e.hasMoreElements()) {
            String resource;
            String key = e.nextElement();
            if (!key.endsWith(".icon") || (resource = guiBundle.getString(key)).isEmpty()) continue;
            if (Character.isDigit(resource.charAt(0))) {
                SwingTools.createIcon(resource);
                continue;
            }
            SwingTools.createIcon("16/" + resource);
            SwingTools.createIcon("24/" + resource);
        }
    }

    public static String transformToolTipText(String description) {
        return SwingTools.transformToolTipText(description, true, 100);
    }

    public static String transformToolTipText(String description, boolean addHTMLTags, int lineLength) {
        String[] lines;
        String completeText = Tools.escapeHTML(description.trim());
        StringBuffer result = new StringBuffer();
        if (addHTMLTags) {
            result.append("<html>");
        }
        completeText = Tools.transformAllLineSeparators(completeText);
        for (String text : lines = completeText.split("\n")) {
            boolean first = true;
            while (text.length() > lineLength) {
                int spaceIndex = text.indexOf(" ", lineLength);
                if (!first) {
                    result.append("<br>");
                }
                first = false;
                if (spaceIndex >= 0) {
                    result.append(text.substring(0, spaceIndex));
                    text = text.substring(spaceIndex + 1);
                    continue;
                }
                result.append(text);
                text = "";
            }
            if (!first && text.length() > 0) {
                result.append("<br>");
            }
            result.append(text);
            result.append("<br>");
        }
        if (addHTMLTags) {
            result.append("</html>");
        }
        return result.toString();
    }

    public static String addLinebreaks(String message) {
        String[] lines;
        if (message == null) {
            return null;
        }
        String completeText = message.trim();
        StringBuffer result = new StringBuffer();
        completeText = Tools.transformAllLineSeparators(completeText);
        for (String text : lines = completeText.split("\n")) {
            boolean first = true;
            while (text.length() > 100) {
                int spaceIndex = text.indexOf(" ", 100);
                if (!first) {
                    result.append(Tools.getLineSeparator());
                }
                first = false;
                if (spaceIndex >= 0) {
                    result.append(text.substring(0, spaceIndex));
                    text = text.substring(spaceIndex + 1);
                    continue;
                }
                result.append(text);
                text = "";
            }
            if (!first && text.length() > 0) {
                result.append(Tools.getLineSeparator());
            }
            result.append(text);
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }

    public static void showResultsDialog(String i18nKey, JComponent results, Object ... i18nArgs) {
        ResultViewDialog dialog = new ResultViewDialog(i18nKey, results, i18nArgs);
        dialog.setVisible(true);
    }

    public static void showMessageDialog(String key, Object ... keyArguments) {
        MessageDialog dialog = new MessageDialog(key, keyArguments);
        dialog.setVisible(true);
    }

    public static void showMessageDialog(String key, JComponent component, Object ... keyArguments) {
        MessageDialog dialog = new MessageDialog(key, component, keyArguments);
        dialog.setVisible(true);
    }

    public static int showConfirmDialog(String key, int mode, Object ... keyArguments) {
        ConfirmDialog dialog = new ConfirmDialog(key, mode, false, keyArguments);
        dialog.setVisible(true);
        return dialog.getReturnOption();
    }

    public static String showInputDialog(String key, String text, Object ... keyArguments) {
        InputDialog dialog = new InputDialog(key, text, keyArguments);
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            return dialog.getInputText();
        }
        return null;
    }

    public static Object showInputDialog(String key, Object[] selectionValues, Object initialSelectionVale, Object ... keyArguments) {
        SelectionInputDialog dialog = new SelectionInputDialog(key, selectionValues, initialSelectionVale, keyArguments);
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            return dialog.getInputSelection();
        }
        return null;
    }

    public static Object showInputDialog(String key, boolean editable, Object[] selectionValues, Object initialSelectionVale, Object ... keyArguments) {
        SelectionInputDialog dialog = new SelectionInputDialog(key, editable, selectionValues, initialSelectionVale, keyArguments);
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            return dialog.getInputSelection();
        }
        return null;
    }

    public static void showVerySimpleErrorMessage(final String key, final Object ... arguments) {
        if (SwingUtilities.isEventDispatchThread()) {
            ErrorDialog dialog = new ErrorDialog(key, arguments);
            dialog.setVisible(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog dialog = new ErrorDialog(key, arguments);
                    dialog.setVisible(true);
                }
            });
        }
    }

    public static void showSimpleErrorMessage(String key, Throwable e, Object ... arguments) {
        SwingTools.showSimpleErrorMessage(key, e, true, arguments);
    }

    public static void showSimpleErrorMessage(final String key, final Throwable e, final boolean displayExceptionMessage, final Object ... arguments) {
        if ("true".equals(System.getProperty("rapidminer.general.debugmode"))) {
            LogService.getRoot().log(Level.WARNING, e.getMessage(), e);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ExtendedErrorDialog dialog = new ExtendedErrorDialog(key, e, displayExceptionMessage, arguments);
            dialog.setVisible(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtendedErrorDialog dialog = new ExtendedErrorDialog(key, e, displayExceptionMessage, arguments);
                    dialog.setVisible(true);
                }
            });
        }
    }

    public static void showSimpleErrorMessage(final String key, final String errorMessage, final boolean displayExceptionMessage, final Object ... arguments) {
        if (SwingUtilities.isEventDispatchThread()) {
            ExtendedErrorDialog dialog = new ExtendedErrorDialog(key, errorMessage, displayExceptionMessage, arguments);
            dialog.setVisible(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtendedErrorDialog dialog = new ExtendedErrorDialog(key, errorMessage, displayExceptionMessage, arguments);
                    dialog.setVisible(true);
                }
            });
        }
        if (System.getProperty("rapidminer.general.debugmode").equals("true")) {
            LogService.getRoot().log(Level.WARNING, errorMessage);
        }
    }

    public static void showSimpleErrorMessage(String key, String errorMessage, Object ... arguments) {
        SwingTools.showSimpleErrorMessage(key, errorMessage, false, arguments);
    }

    public static void showFinalErrorMessage(String key, Throwable e, boolean displayExceptionMessage, Object ... objects) {
        if (System.getProperty("rapidminer.general.debugmode").equals("true")) {
            LogService.getRoot().log(Level.SEVERE, e.getMessage(), e);
        }
        ExtendedErrorDialog dialog = new ExtendedErrorDialog(key, e, displayExceptionMessage, objects);
        dialog.setVisible(true);
    }

    public static void showFinalErrorMessage(String key, Throwable e, Object ... objects) {
        SwingTools.showFinalErrorMessage(key, e, false, objects);
    }

    public static File chooseFile(Component parent, File file, boolean open, String extension, String extensionDescription) {
        return SwingTools.chooseFile(parent, null, file, open, extension, extensionDescription);
    }

    public static File chooseFile(Component parent, String i18nKey, File file, boolean open, String extension, String extensionDescription) {
        return SwingTools.chooseFile(parent, i18nKey, file, open, false, extension, extensionDescription);
    }

    public static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, String extension, String extensionDescription) {
        return SwingTools.chooseFile(parent, null, file, open, onlyDirs, extension, extensionDescription);
    }

    public static File chooseFile(Component parent, String i18nKey, File file, boolean open, boolean onlyDirs, String extension, String extensionDescription) {
        String[] stringArray;
        String[] stringArray2;
        if (extension == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = extension;
        }
        if (extensionDescription == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = extensionDescription;
        }
        return SwingTools.chooseFile(parent, i18nKey, file, open, onlyDirs, stringArray2, stringArray);
    }

    public static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, String[] extensions, String[] extensionDescriptions) {
        return SwingTools.chooseFile(parent, null, file, open, onlyDirs, extensions, extensionDescriptions);
    }

    public static File chooseFile(Component parent, String i18nKey, File file, boolean open, boolean onlyDirs, String[] extensions, String[] extensionDescriptions) {
        FileFilter[] filters = null;
        if (extensions != null) {
            filters = new FileFilter[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                filters[i] = new SimpleFileFilter(extensionDescriptions[i] + " (*." + extensions[i] + ")", "." + extensions[i]);
            }
        }
        return SwingTools.chooseFile(parent, i18nKey, file, open, onlyDirs, filters);
    }

    private static File chooseFile(Component parent, String i18nKey, File file, boolean open, boolean onlyDirs, FileFilter[] fileFilters) {
        if (parent == null) {
            parent = RapidMinerGUI.getMainFrame();
        }
        String key = "file_chooser." + (i18nKey != null ? i18nKey : (open ? (onlyDirs ? "open_directory" : "open") : "save"));
        JFileChooser fileChooser = SwingTools.createFileChooser(key, file, onlyDirs, fileFilters);
        int returnValue = open ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        switch (returnValue) {
            case 0: {
                File parentFile;
                File selectedFile = fileChooser.getSelectedFile();
                FileFilter selectedFilter = fileChooser.getFileFilter();
                String extension = null;
                if (selectedFilter instanceof SimpleFileFilter) {
                    SimpleFileFilter simpleFF = (SimpleFileFilter)selectedFilter;
                    extension = simpleFF.getExtension();
                }
                if (extension != null && !selectedFile.getAbsolutePath().toLowerCase().endsWith(extension.toLowerCase())) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + extension);
                }
                if (selectedFile != null && (parentFile = selectedFile.getParentFile()) != null) {
                    List<Bookmark> bookmarks = null;
                    File bookmarksFile = new File(ParameterService.getUserRapidMinerDir(), ".bookmarks");
                    if (bookmarksFile.exists()) {
                        bookmarks = BookmarkIO.readBookmarks(bookmarksFile);
                        Iterator<Bookmark> b = bookmarks.iterator();
                        while (b.hasNext()) {
                            Bookmark bookmark = b.next();
                            if (!bookmark.getName().equals("--- Last Directory")) continue;
                            b.remove();
                        }
                        bookmarks.add(new Bookmark("--- Last Directory", parentFile.getAbsolutePath()));
                        Collections.sort(bookmarks);
                        BookmarkIO.writeBookmarks(bookmarks, bookmarksFile);
                    }
                }
                return selectedFile;
            }
        }
        return null;
    }

    public static JFileChooser createFileChooser(String i18nKey, File file, boolean onlyDirs, FileFilter[] fileFilters) {
        File directory = null;
        directory = file != null ? (file.isDirectory() ? file : file.getAbsoluteFile().getParentFile()) : FileSystemView.getFileSystemView().getDefaultDirectory();
        ExtendedJFileChooser fileChooser = new ExtendedJFileChooser(i18nKey, directory, new Object[0]);
        if (onlyDirs) {
            fileChooser.setFileSelectionMode(1);
        }
        if (fileFilters != null) {
            fileChooser.setAcceptAllFileFilterUsed(true);
            for (int i = 0; i < fileFilters.length; ++i) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
            }
        }
        if (file != null) {
            fileChooser.setSelectedFile(file);
        }
        return fileChooser;
    }

    public static JPanel createTextPanel(String title, String text) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("<html><h3>" + title + "</h3>" + (text != null ? "<p>" + text + "</p>" : "") + "</html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        panel.add((Component)label, "North");
        return panel;
    }

    public static String text2DisplayHtml(String text) {
        String result = "<html><head><style type=text/css>body { font-family:sans-serif; font-size:12pt; }</style></head><body>" + text + "</body></html>";
        result = SwingTools.text2SimpleHtml(result);
        while (result.indexOf("<icon>") != -1) {
            int startIndex = result.indexOf("<icon>");
            int endIndex = result.indexOf("</icon>");
            String start = result.substring(0, startIndex);
            String end = result.substring(endIndex + 7);
            String icon = result.substring(startIndex + 6, endIndex).trim().toLowerCase();
            URL url = Tools.getResource("icons/" + icon + ".png");
            if (url != null) {
                result = start + "<img src=\"" + url + "\"/>" + end;
                continue;
            }
            result = start + end;
        }
        return result;
    }

    private static String text2SimpleHtml(String htmlText) {
        if (htmlText == null) {
            return null;
        }
        String replaceString = htmlText;
        StringBuffer result = new StringBuffer();
        boolean afterClose = true;
        int currentLineLength = 0;
        for (int i = 0; i < replaceString.length(); ++i) {
            char c = replaceString.charAt(i);
            if (afterClose && c == ' ') continue;
            if (c == '<' && !afterClose) {
                result.append(Tools.getLineSeparator());
                currentLineLength = 0;
            }
            afterClose = false;
            result.append(c);
            if (++currentLineLength > 70 && c == ' ') {
                result.append(Tools.getLineSeparator());
                currentLineLength = 0;
            }
            if (c != '>') continue;
            result.append(Tools.getLineSeparator());
            currentLineLength = 0;
            afterClose = true;
        }
        return result.toString();
    }

    public static Color getPointColor(double value) {
        return new Color(Color.HSBtoRGB((float)(0.68 * (1.0 - value)), 1.0f, 1.0f));
    }

    public static Color getPointColor(double value, double max, double min) {
        value = (value - min) / (max - min);
        return SwingTools.getPointColor(value);
    }

    public static TextAreaDefaults getTextAreaDefaults() {
        TextAreaDefaults defaults = TextAreaDefaults.getDefaults();
        defaults.styles = SwingTools.getSyntaxStyles();
        return defaults;
    }

    public static SyntaxStyle[] getSyntaxStyles() {
        SyntaxStyle[] styles = SyntaxUtilities.getDefaultSyntaxStyles();
        styles[1] = new SyntaxStyle(new Color(0x990033), true, false);
        styles[2] = new SyntaxStyle(Color.black, true, false);
        styles[6] = new SyntaxStyle(Color.black, false, true);
        styles[7] = new SyntaxStyle(new Color(255, 51, 204), false, false);
        styles[8] = new SyntaxStyle(new Color(255, 51, 204), false, false);
        styles[3] = new SyntaxStyle(new Color(51, 51, 255), false, false);
        styles[4] = new SyntaxStyle(new Color(51, 51, 255), false, false);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true);
        styles[9] = new SyntaxStyle(Color.black, false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        return styles;
    }

    public static String toHTMLString(Ports<? extends Port> ports) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Port port : ports.getAllPorts()) {
            if (!first) {
                b.append(", ");
            } else {
                first = false;
            }
            b.append(port.getName());
            String desc = port.getDescription();
            if (desc.length() <= 0) continue;
            b.append(": ");
            b.append(port.getDescription());
        }
        return b.toString();
    }

    public static void showLongMessage(String i18nKey, String message) {
        LongMessageDialog dialog = new LongMessageDialog(i18nKey, message, new Object[0]);
        dialog.setVisible(true);
    }

    public static void setEnabledRecursive(Component c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                SwingTools.setEnabledRecursive(child, enabled);
            }
        }
    }

    public static void setOpaqueRecursive(Component c, boolean enabled) {
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(enabled);
        }
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                SwingTools.setOpaqueRecursive(child, enabled);
            }
        }
    }

    public static void setProcessEditorsEnabled(boolean enabled) {
        MainFrame mainFrame = RapidMinerGUI.getMainFrame();
        SwingTools.setEnabledRecursive(mainFrame.getProcessPanel().getComponent(), enabled);
        SwingTools.setEnabledRecursive(mainFrame.getPropertyPanel().getComponent(), enabled);
        SwingTools.setEnabledRecursive(mainFrame.getOperatorTree(), enabled);
        SwingTools.setEnabledRecursive(mainFrame.getProcessContextEditor().getComponent(), enabled);
        SwingTools.setEnabledRecursive(mainFrame.getXMLEditor(), enabled);
        mainFrame.getActions().enableActions();
    }

    static {
        SwingTools.setupFrameIcons(DEFAULT_FRAME_ICON_BASE_NAME);
        ICON_CACHE = new HashMap<String, ImageIcon>();
        ICON_LOCK = new Object();
    }
}

