/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.ProgressThreadDialog;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements ProcessEditor {
    private final ProcessListener processListener = new ProcessListener(){

        @Override
        public void processStarts(Process process) {
            StatusBar.this.rootOperator = null;
            StatusBar.this.specialText = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.operatorLabel.setText("");
                    StatusBar.this.trafficLightLabel.setIcon(RUNNING_ICON);
                }
            });
        }

        @Override
        public void processStartedOperator(Process process, Operator op) {
            if (StatusBar.this.rootOperator == null) {
                StatusBar.this.rootOperator = new OperatorEntry(op);
            } else {
                StatusBar.this.rootOperator.addOperator(op);
            }
        }

        @Override
        public void processFinishedOperator(Process process, Operator op) {
            if (StatusBar.this.rootOperator != null) {
                StatusBar.this.rootOperator.removeOperator(op);
            }
        }

        @Override
        public void processEnded(Process process) {
            StatusBar.this.rootOperator = null;
            StatusBar.this.specialText = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.operatorLabel.setText("");
                    StatusBar.this.trafficLightLabel.setIcon(INACTIVE_ICON);
                }
            });
        }
    };
    private final BreakpointListener breakpointListener = new BreakpointListener(){

        @Override
        public void resume() {
            StatusBar.this.breakpoint = -1;
            if (StatusBar.this.rootOperator != null) {
                StatusBar.this.setText();
            } else {
                StatusBar.this.operatorLabel.setText(" ");
            }
            StatusBar.this.trafficLightLabel.setIcon(RUNNING_ICON);
        }

        @Override
        public void breakpointReached(Process process, Operator op, IOContainer io, int location) {
            StatusBar.this.breakpoint = location;
            StatusBar.this.operatorLabel.setText("[" + op.getApplyCount() + "] " + op.getName() + ": breakpoint reached " + BreakpointListener.BREAKPOINT_POS_NAME[StatusBar.this.breakpoint] + " operator, press resume...");
            StatusBar.this.trafficLightLabel.setIcon(STOPPED_ICON);
        }
    };
    private static final String INACTIVE_ICON_NAME = "24/bullet_ball_glass_grey.png";
    private static final String RUNNING_ICON_NAME = "24/bullet_ball_glass_green.png";
    private static final String STOPPED_ICON_NAME = "24/bullet_ball_glass_red.png";
    private static final String PENDING_ICON_NAME = "24/bullet_ball_glass_yellow.png";
    private static final Icon INACTIVE_ICON = SwingTools.createIcon("24/bullet_ball_glass_grey.png");
    private static final Icon RUNNING_ICON = SwingTools.createIcon("24/bullet_ball_glass_green.png");
    private static final Icon STOPPED_ICON = SwingTools.createIcon("24/bullet_ball_glass_red.png");
    private static final Icon PENDING_ICON = SwingTools.createIcon("24/bullet_ball_glass_yellow.png");
    public static final int TRAFFIC_LIGHT_INACTIVE = 0;
    public static final int TRAFFIC_LIGHT_RUNNING = 1;
    public static final int TRAFFIC_LIGHT_STOPPED = 2;
    public static final int TRAFFIC_LIGHT_PENDING = 3;
    private static final long serialVersionUID = 1189363377612273467L;
    private final JLabel clockLabel = StatusBar.createLabel(StatusBar.getTime(), true);
    private final JLabel operatorLabel = StatusBar.createLabel("                         ", false);
    private OperatorEntry rootOperator = null;
    private final JLabel trafficLightLabel = new JLabel();
    private final JProgressBar progressBar = new JProgressBar();
    private int breakpoint = -1;
    private String specialText = null;
    private Process process;

    public StatusBar() {
        this(true, true, true);
    }

    public StatusBar(boolean showClock, boolean showTrafficLight, boolean showProgressBar) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        if (showTrafficLight) {
            this.trafficLightLabel.setIcon(INACTIVE_ICON);
            this.trafficLightLabel.setToolTipText("Indicates the current running state.");
            constraints.weightx = 0.0;
            layout.setConstraints(this.trafficLightLabel, constraints);
            this.add(this.trafficLightLabel);
        }
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        layout.setConstraints(this.operatorLabel, constraints);
        this.add(this.operatorLabel);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.gridwidth = -1;
        if (showProgressBar) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
            this.progressBar.setFont(this.progressBar.getFont().deriveFont(8.5f));
            this.progressBar.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && !ProgressThreadDialog.getInstance().isVisible()) {
                        ProgressThreadDialog.getInstance().setVisible(true);
                    }
                }
            });
            layout.setConstraints(this.progressBar, constraints);
            this.add(this.progressBar);
        }
        if (showClock) {
            this.clockLabel.setToolTipText("The current system time.");
            constraints.weightx = 0.0;
            constraints.gridwidth = 0;
            layout.setConstraints(this.clockLabel, constraints);
            this.add(this.clockLabel);
        }
    }

    public void startClockThread() {
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusBar.this.clockLabel.setText(StatusBar.getTime());
                if (StatusBar.this.specialText != null && StatusBar.this.specialText.trim().length() > 0) {
                    StatusBar.this.setText(StatusBar.this.specialText);
                } else {
                    StatusBar.this.setText();
                }
            }
        }).start();
    }

    private static Border createBorder() {
        return new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                Color highlight = c.getBackground().brighter().brighter();
                Color shadow = c.getBackground().darker().darker();
                Color oldColor = g.getColor();
                g.translate(x, y);
                g.setColor(shadow);
                g.drawLine(3, 0, 3, h - 2);
                g.drawLine(3, 0, w - 3, 0);
                g.setColor(highlight);
                g.drawLine(3, h - 2, w - 3, h - 2);
                g.drawLine(w - 3, 1, w - 3, h - 2);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 4, 2, 3);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        };
    }

    private static JLabel createLabel(String text, boolean border) {
        JLabel label = new JLabel(text);
        if (border) {
            label.setBorder(StatusBar.createBorder());
        }
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }

    private static String getTime() {
        return DateFormat.getTimeInstance().format(new Date());
    }

    public void setTrafficLight(int trafficLightState) {
        switch (trafficLightState) {
            case 1: {
                this.trafficLightLabel.setIcon(RUNNING_ICON);
                break;
            }
            case 2: {
                this.trafficLightLabel.setIcon(STOPPED_ICON);
                break;
            }
            case 3: {
                this.trafficLightLabel.setIcon(PENDING_ICON);
                break;
            }
            default: {
                this.trafficLightLabel.setIcon(INACTIVE_ICON);
            }
        }
    }

    public void setSpecialText(String specialText) {
        this.specialText = specialText;
        this.setText(this.specialText);
    }

    public void clearSpecialText() {
        this.specialText = null;
        this.setText();
    }

    private synchronized void setText(String text) {
        this.operatorLabel.setText(text);
    }

    private void setText() {
        if (this.rootOperator != null) {
            this.setText(this.rootOperator.toString(this.rootOperator, System.currentTimeMillis()));
        } else {
            this.setText("");
        }
    }

    public void setProgress(final String label, final int completed, final int total) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (completed < total) {
                    if (!StatusBar.this.progressBar.isEnabled()) {
                        StatusBar.this.progressBar.setEnabled(true);
                    }
                    StatusBar.this.progressBar.setString(label);
                    StatusBar.this.progressBar.setMaximum(total);
                    StatusBar.this.progressBar.setValue(completed);
                } else {
                    StatusBar.this.progressBar.setString("");
                    StatusBar.this.progressBar.setValue(0);
                    StatusBar.this.progressBar.setEnabled(false);
                }
                StatusBar.this.progressBar.repaint();
            }
        });
    }

    @Override
    public void processChanged(Process process) {
        if (this.process != process) {
            if (this.process != null) {
                this.process.removeBreakpointListener(this.breakpointListener);
                this.process.getRootOperator().removeProcessListener(this.processListener);
            }
            this.process = process;
            if (this.process != null) {
                this.process.addBreakpointListener(this.breakpointListener);
                this.process.getRootOperator().addProcessListener(this.processListener);
            }
        }
    }

    @Override
    public void processUpdated(Process process) {
    }

    @Override
    public void setSelection(List<Operator> selection) {
    }

    private static class OperatorEntry {
        private final Collection<OperatorEntry> children = new LinkedList<OperatorEntry>();
        private final Operator operator;

        public OperatorEntry(Operator operator) {
            this.operator = operator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOperator(Operator operator) {
            Collection<OperatorEntry> collection = this.children;
            synchronized (collection) {
                if (this.operator == operator.getParent()) {
                    this.children.add(new OperatorEntry(operator));
                } else {
                    for (OperatorEntry childEntry : this.children) {
                        childEntry.addOperator(operator);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeOperator(Operator operator) {
            Collection<OperatorEntry> collection = this.children;
            synchronized (collection) {
                Iterator<OperatorEntry> iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    OperatorEntry childEntry = iterator.next();
                    if (childEntry.getOperator() == operator) {
                        iterator.remove();
                        continue;
                    }
                    childEntry.removeOperator(operator);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString(OperatorEntry entry, long time) {
            Collection<OperatorEntry> collection = this.children;
            synchronized (collection) {
                StringBuffer buffer = new StringBuffer();
                Operator currentOperator = entry.getOperator();
                buffer.append("[" + currentOperator.getApplyCount() + "] " + currentOperator.getName() + "  " + Tools.formatDuration(time - currentOperator.getStartTime()));
                Iterator<OperatorEntry> iterator = this.children.iterator();
                if (iterator.hasNext()) {
                    buffer.append(" \u21b3 ");
                }
                while (iterator.hasNext()) {
                    OperatorEntry childEntry = iterator.next();
                    if (this.children.size() > 1) {
                        buffer.append(" ( ");
                    }
                    buffer.append(childEntry.toString(childEntry, time));
                    if (this.children.size() > 1) {
                        buffer.append(" ) ");
                    }
                    if (!iterator.hasNext()) continue;
                    buffer.append(" | ");
                }
                return buffer.toString();
            }
        }

        public Operator getOperator() {
            return this.operator;
        }
    }
}

