/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SplashScreen
extends JPanel
implements ActionListener {
    private static final int EXTENSION_GAP = 400;
    private static final float EXTENSION_FADE_TIME = 1000.0f;
    private static final int MAX_NUMBER_EXTENSION_ICONS = 7;
    private static final long serialVersionUID = -1525644776910410809L;
    private static final Paint MAIN_PAINT = Color.BLACK;
    public static Image backgroundImage = null;
    private static final int MARGIN = 10;
    private static final String PROPERTY_FILE = "splash_infos.properties";
    private transient Image productLogo;
    private Properties properties;
    private JFrame splashScreenFrame = new JFrame();
    private String message = "Starting...";
    private boolean infosVisible;
    private Timer animationTimer;
    private List<Runnable> animationRenderers = new LinkedList<Runnable>();
    private ArrayList<Pair<BufferedImage, Long>> extensionIcons = new ArrayList();
    private long lastExtensionAdd = 0L;

    public SplashScreen(String productVersion, Image productLogo) {
        this(productLogo, SplashScreen.createDefaultProperties(productVersion));
    }

    public SplashScreen(String productVersion, Image productLogo, URL propertyFile) {
        this(productLogo, SplashScreen.createProperties(productVersion, propertyFile));
    }

    public SplashScreen(Image productLogo, Properties properties) {
        this.properties = properties;
        this.productLogo = productLogo;
        this.splashScreenFrame = new JFrame(properties.getProperty("name"));
        this.splashScreenFrame.getContentPane().add(this);
        SwingTools.setFrameIcon(this.splashScreenFrame);
        this.splashScreenFrame.setUndecorated(true);
        if (backgroundImage != null) {
            this.splashScreenFrame.setSize(backgroundImage.getWidth(this), backgroundImage.getHeight(this));
        } else {
            this.splashScreenFrame.setSize(450, 350);
        }
        this.splashScreenFrame.setLocationRelativeTo(null);
        this.animationTimer = new Timer(10, this);
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    private static Properties createDefaultProperties(String productVersion) {
        return SplashScreen.createProperties(productVersion, Tools.getResource(PROPERTY_FILE));
    }

    private static Properties createProperties(String productVersion, URL propertyFile) {
        Properties properties = new Properties();
        if (propertyFile != null) {
            try {
                InputStream in = propertyFile.openStream();
                properties.load(in);
                in.close();
            }
            catch (Exception e) {
                LogService.getGlobal().logError("Cannot read splash screen infos: " + e.getMessage());
            }
        }
        properties.setProperty("version", productVersion);
        return properties;
    }

    public void showSplashScreen() {
        this.splashScreenFrame.setVisible(true);
    }

    public JFrame getSplashScreenFrame() {
        return this.splashScreenFrame;
    }

    public void dispose() {
        this.splashScreenFrame.dispose();
        this.splashScreenFrame = null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.drawMain((Graphics2D)g);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int size = this.extensionIcons.size();
        if (size > 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(400, 140);
            g2d.scale(0.5, 0.5);
            long currentTimeMillis = System.currentTimeMillis();
            int numberToShow = 0;
            for (Pair<BufferedImage, Long> pair : this.extensionIcons) {
                if (currentTimeMillis <= pair.getSecond()) continue;
                ++numberToShow;
            }
            int shiftX = 51;
            for (int i = 0; i < numberToShow; ++i) {
                float min;
                Pair<BufferedImage, Long> pair;
                if (numberToShow > i + 7) {
                    pair = this.extensionIcons.get(i + 7);
                    min = Math.min((float)(currentTimeMillis - pair.getSecond()) / 1000.0f, 1.0f);
                    g2d.setComposite(AlphaComposite.getInstance(3, 1.0f - min));
                } else {
                    pair = this.extensionIcons.get(i);
                    min = Math.min((float)(currentTimeMillis - pair.getSecond()) / 1000.0f, 1.0f);
                    g2d.setComposite(AlphaComposite.getInstance(3, min));
                }
                g2d.drawImage(this.extensionIcons.get(i).getFirst(), null, -(i % 7) * shiftX, 0);
            }
        }
    }

    public void drawMain(Graphics2D g) {
        g.setPaint(MAIN_PAINT);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (backgroundImage != null) {
            g.drawImage(backgroundImage, 0, 0, this);
        }
        if (this.productLogo != null) {
            g.drawImage(this.productLogo, this.getWidth() / 2 - this.productLogo.getWidth(this) / 2, 90, this);
        }
        g.setColor(SwingTools.BROWN_FONT_COLOR);
        if (this.message != null) {
            g.setFont(new Font("SansSerif", 1, 11));
            this.drawString(g, this.message, 255);
        }
        if (this.infosVisible) {
            g.setFont(new Font("SansSerif", 0, 10));
            this.drawString(g, this.properties.getProperty("name") + " " + this.properties.getProperty("version"), 275);
            this.drawString(g, this.properties.getProperty("license"), 290);
            this.drawString(g, this.properties.getProperty("warranty"), 305);
            this.drawString(g, this.properties.getProperty("copyright"), 320);
            this.drawString(g, this.properties.getProperty("more"), 335);
        }
    }

    private void drawString(Graphics2D g, String text, int height) {
        if (text == null) {
            return;
        }
        float xPos = 10.0f;
        float yPos = height;
        g.drawString(text, xPos, yPos);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setInfosVisible(boolean b) {
        this.infosVisible = b;
    }

    public void addExtension(Plugin plugin) {
        ImageIcon extensionIcon = plugin.getExtensionIcon();
        if (extensionIcon != null) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastExtensionAdd + 400L) {
                currentTimeMillis = this.lastExtensionAdd + 400L;
            }
            this.lastExtensionAdd = currentTimeMillis;
            BufferedImage bufferedImage = new BufferedImage(48, 48, 2);
            Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
            graphics.drawImage(extensionIcon.getImage(), 0, 0, null);
            this.extensionIcons.add(new Pair<BufferedImage, Long>(bufferedImage, currentTimeMillis));
        }
    }

    public void addAnimationRenderer(Runnable runable) {
        this.animationRenderers.add(runable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (Runnable runnable : this.animationRenderers) {
            runnable.run();
        }
        this.repaint();
    }

    static {
        try {
            URL url;
            if (backgroundImage == null && (url = Tools.getResource("splashscreen_community.png")) != null) {
                backgroundImage = ImageIO.read(url);
            }
        }
        catch (IOException e) {
            LogService.getGlobal().logWarning("Cannot load images for splash screen. Using empty splash screen...");
        }
    }
}

