/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class ResourceTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private final String i18KeyPrefix;
    private boolean largeIcons = false;

    public ResourceTabbedPane(String i18KeyPrefix) {
        this.i18KeyPrefix = i18KeyPrefix;
    }

    public ResourceTabbedPane(String i18KeyPrefix, int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.i18KeyPrefix = i18KeyPrefix;
    }

    public ResourceTabbedPane(String i18KeyPrefix, int tabPlacement) {
        super(tabPlacement);
        this.i18KeyPrefix = i18KeyPrefix;
    }

    public void addTabI18N(String key, Component component, String ... i18nArgs) {
        String mne;
        String name = i18nArgs != null && i18nArgs.length > 0 ? this.formatMessage(key, "label", i18nArgs) : this.getMessage(key, "label");
        ImageIcon icon = null;
        String iconName = this.getMessageOrNull(key, "icon");
        if (iconName != null) {
            icon = SwingTools.createIcon((this.isLargeIcons() ? "24/" : "16/") + iconName);
        }
        this.addTab(name, icon, component);
        int index = this.getTabCount() - 1;
        String tip = i18nArgs != null && i18nArgs.length > 0 ? this.formatMessage(key, "tip", i18nArgs) : this.getMessageOrNull(key, "tip");
        if (tip != null) {
            this.setToolTipTextAt(index, tip);
        }
        if ((mne = this.getMessageOrNull(key, "mne")) != null) {
            if (name.indexOf(mne.charAt(0)) == -1) {
                if (name.indexOf(mne.toUpperCase().charAt(0)) != -1) {
                    mne = mne.toUpperCase();
                    LogService.getRoot().warning("Mnemonic key " + mne + " not found for tab " + this.i18KeyPrefix + "." + key + " (" + name + "), converting to upper case.");
                } else {
                    LogService.getRoot().warning("Mnemonic key " + mne + " not found for action " + this.i18KeyPrefix + "." + key + " (" + name + ")");
                }
            }
            this.setMnemonicAt(index, mne.charAt(0));
        }
    }

    private String getMessage(String tabName, String key) {
        return I18N.getMessage(I18N.getGUIBundle(), "gui.tabs." + this.i18KeyPrefix + "." + tabName + "." + key, new Object[0]);
    }

    private String formatMessage(String tabName, String key, Object[] args) {
        String message = this.getMessageOrNull(tabName, key);
        if (message != null) {
            return MessageFormat.format(message, args);
        }
        return null;
    }

    private String getMessageOrNull(String tabName, String key) {
        return I18N.getMessageOrNull(I18N.getGUIBundle(), "gui.tabs." + this.i18KeyPrefix + "." + tabName + "." + key, new Object[0]);
    }

    public void setLargeIcons(boolean largeIcons) {
        this.largeIcons = largeIcons;
    }

    public boolean isLargeIcons() {
        return this.largeIcons;
    }
}

