/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.vlsolutions.swing.docking.DockKey;
import javax.swing.ImageIcon;

public class ResourceDockKey
extends DockKey {
    public ResourceDockKey(String resourceKey) {
        super(resourceKey);
        this.setName(ResourceDockKey.getMessage(resourceKey + ".name"));
        this.setTooltip(ResourceDockKey.getMessage(resourceKey + ".tip"));
        String iconName = ResourceDockKey.getMessageOrNull(resourceKey + ".icon");
        if (iconName != null) {
            ImageIcon icon = SwingTools.createIcon("16/" + iconName);
            if (icon != null) {
                this.setIcon(icon);
            } else {
                LogService.getRoot().warning("Missing icon: " + iconName);
            }
        }
        this.setFloatEnabled(true);
        this.setCloseEnabled(true);
        this.setAutoHideEnabled(true);
        this.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
    }

    private static String getMessage(String key) {
        return I18N.getMessage(I18N.getGUIBundle(), "gui.dockkey." + key, new Object[0]);
    }

    private static String getMessageOrNull(String key) {
        return I18N.getMessageOrNull(I18N.getGUIBundle(), "gui.dockkey." + key, new Object[0]);
    }
}

