/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.ConditionalAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class ResourceAction
extends ConditionalAction {
    private static final long serialVersionUID = -3699425760142415331L;
    private final String key;

    public ResourceAction(String i18nKey, Object ... i18nArgs) {
        this(false, i18nKey, i18nArgs);
        this.setCondition(9, 0);
    }

    public ResourceAction(boolean smallIcon, String i18nKey, Object ... i18nArgs) {
        super(i18nArgs == null || i18nArgs.length == 0 ? ResourceAction.getMessage(i18nKey + ".label") : MessageFormat.format(ResourceAction.getMessage(i18nKey + ".label"), i18nArgs));
        String acc;
        String icon;
        String tip;
        this.key = i18nKey;
        String mne = ResourceAction.getMessageOrNull(i18nKey + ".mne");
        if (mne != null && mne.length() > 0) {
            String name = (String)this.getValue("Name");
            if (name != null && name.length() > 0 && name.indexOf(mne.charAt(0)) == -1) {
                if (name.indexOf(mne.toUpperCase().charAt(0)) != -1) {
                    mne = mne.toUpperCase();
                    LogService.getRoot().warning("Mnemonic key " + mne + " not found for action " + i18nKey + " (" + name + "), converting to upper case.");
                } else {
                    LogService.getRoot().warning("Mnemonic key " + mne + " not found for action " + i18nKey + " (" + name + ")");
                }
            }
            this.putValue("MnemonicKey", mne.charAt(0));
        }
        if ((tip = ResourceAction.getMessageOrNull(i18nKey + ".tip")) != null) {
            this.putValue("ShortDescription", i18nArgs == null || i18nArgs.length == 0 ? tip : MessageFormat.format(tip, i18nArgs));
        }
        if ((icon = ResourceAction.getMessageOrNull(i18nKey + ".icon")) != null) {
            ImageIcon small = SwingTools.createIcon("16/" + icon);
            ImageIcon large = SwingTools.createIcon("24/" + icon);
            this.putValue("SwingLargeIconKey", smallIcon ? (small != null ? small : large) : large);
            this.putValue("SmallIcon", small != null ? small : large);
        }
        if ((acc = ResourceAction.getMessageOrNull(i18nKey + ".acc")) != null) {
            KeyStroke stroke = KeyStroke.getKeyStroke(acc);
            this.putValue("AcceleratorKey", stroke);
        }
    }

    private static String getMessage(String key) {
        return I18N.getMessage(I18N.getGUIBundle(), "gui.action." + key, new Object[0]);
    }

    private static String getMessageOrNull(String key) {
        return I18N.getMessageOrNull(I18N.getGUIBundle(), "gui.action." + key, new Object[0]);
    }

    public void addToActionMap(JComponent component, int condition) {
        KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
        if (keyStroke != null) {
            component.getInputMap(condition).put(keyStroke, this.key);
            component.getActionMap().put(this.key, this);
        } else {
            LogService.getRoot().warning("Cannot add action " + this.key + " to input map: no accelerator defined.");
        }
    }

    public String getKey() {
        return this.key;
    }
}

