/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.actions.StoreInRepositoryAction;
import com.rapidminer.gui.tools.PrintingTools;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObject;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class RadioCardPanel
extends JPanel {
    private static final long serialVersionUID = 2929637220390538982L;
    private final CardLayout layout = new CardLayout();
    private final JPanel mainPanel = new JPanel(this.layout);
    private final ViewToolBar toolBar = new ViewToolBar();
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private Runnable delayedAddition = null;
    private int counter = 0;

    public RadioCardPanel(String name, IOObject object) {
        this(name, object, true, true);
    }

    public RadioCardPanel(String name, IOObject object, boolean showRepositoryStorageButton, boolean showExportMenuButton) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.toolBar, "North");
        if (showRepositoryStorageButton) {
            this.toolBar.add(new StoreInRepositoryAction(object), 1);
        }
        if (showExportMenuButton) {
            DropDownButton exportButton = PrintingTools.makeExportPrintDropDownButton(this.mainPanel, (object instanceof ResultObject ? ((ResultObject)object).getName() : "result") + " " + object.getSource());
            exportButton.addToToolBar(this.toolBar, 1);
        }
    }

    public void addCard(final String name, final Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(null);
        }
        if (this.counter == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RadioCardPanel.this.mainPanel.add(component, name);
                }
            });
            this.delayedAddition = new Runnable(){

                @Override
                public void run() {
                    JRadioButton viewButton = new JRadioButton(name);
                    viewButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RadioCardPanel.this.showCard(name);
                        }
                    });
                    RadioCardPanel.this.toolBar.add(viewButton);
                    RadioCardPanel.this.buttonGroup.add(viewButton);
                    viewButton.setSelected(true);
                }
            };
        } else {
            if (this.counter == 1) {
                SwingUtilities.invokeLater(this.delayedAddition);
                this.delayedAddition = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RadioCardPanel.this.mainPanel.add(component, name);
                    JRadioButton viewButton = new JRadioButton(name);
                    viewButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RadioCardPanel.this.showCard(name);
                        }
                    });
                    RadioCardPanel.this.toolBar.add(viewButton);
                    RadioCardPanel.this.buttonGroup.add(viewButton);
                }
            });
        }
        ++this.counter;
    }

    private void showCard(String name) {
        this.layout.show(this.mainPanel, name);
    }
}

