/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ProgressDialog;
import com.rapidminer.gui.tools.ProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressUtils {
    public static ProgressMonitor createProgressMonitor(Component owner, int total, boolean indeterminate, int waitingTimeBeforeDialogAppears, boolean modal) {
        return ProgressUtils.createProgressMonitor(owner, "Progress", total, indeterminate, waitingTimeBeforeDialogAppears, modal);
    }

    public static ProgressMonitor createProgressMonitor(Component owner, String title, int total, boolean indeterminate, int waitingTimeBeforeDialogAppears, boolean modal) {
        ProgressMonitor monitor = new ProgressMonitor(total, indeterminate, waitingTimeBeforeDialogAppears);
        Window window = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
        monitor.addChangeListener(new MonitorListener(window, title, monitor, modal));
        return monitor;
    }

    static class MonitorListener
    implements ChangeListener,
    ActionListener {
        private String title;
        private ProgressMonitor monitor;
        private Window owner;
        private Timer timer;
        private boolean modal;

        public MonitorListener(Window owner, String title, ProgressMonitor monitor, boolean modal) {
            this.title = title;
            this.owner = owner;
            this.monitor = monitor;
            this.modal = modal;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ProgressMonitor monitor = (ProgressMonitor)ce.getSource();
            if (monitor.getCurrent() != monitor.getTotal()) {
                if (this.timer == null) {
                    this.timer = new Timer(monitor.getWaitingTime(), this);
                    this.timer.setRepeats(false);
                    this.timer.start();
                }
            } else {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                monitor.removeChangeListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.monitor.removeChangeListener(this);
            ProgressDialog dlg = this.owner instanceof Frame ? new ProgressDialog((Frame)this.owner, this.title, this.monitor, this.modal) : new ProgressDialog((Dialog)this.owner, this.title, this.monitor, this.modal);
            dlg.pack();
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
        }
    }
}

