/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ProgressDisplay;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ProgressThreadDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private JLabel mainLabel = new JLabel("-");
    private JProgressBar mainProgressBar = new JProgressBar();
    private JList taskList = new JList(ProgressThread.QUEUE_MODEL);
    private JButton stopButton;
    private static ProgressThreadDialog INSTANCE = new ProgressThreadDialog();

    public static ProgressThreadDialog getInstance() {
        return INSTANCE;
    }

    private ProgressThreadDialog() {
        super("progress_dialog", new Object[0]);
        this.setModal(false);
        ProgressThread.QUEUE_MODEL.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (ProgressThread.QUEUE_MODEL.getSize() == 0) {
                    ProgressThreadDialog.getInstance().dispose();
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.mainProgressBar.setMinimum(0);
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 23;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 4, 4, 4);
        c.weightx = 0.0;
        c.gridwidth = -1;
        main.add((Component)new ResourceLabel("progress_dialog.current", new Object[0]), c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        main.add((Component)this.mainLabel, c);
        main.add((Component)this.mainProgressBar, c);
        c.fill = 1;
        c.insets = new Insets(10, 4, 4, 4);
        main.add((Component)new ResourceLabel("progress_dialog.pending", new Object[0]), c);
        c.insets = new Insets(4, 4, 4, 4);
        c.weighty = 1.0;
        main.add((Component)new JScrollPane(this.taskList), c);
        this.stopButton = new JButton(new ResourceAction("stop", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ProgressThread)ProgressThreadDialog.this.taskList.getSelectedValue()).cancel();
                ProgressThreadDialog.this.enableStopButton();
            }
        });
        this.taskList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProgressThreadDialog.this.enableStopButton();
            }
        });
        this.enableStopButton();
        this.layoutDefault((JComponent)main, this.stopButton, this.makeCloseButton());
    }

    private void enableStopButton() {
        this.stopButton.setEnabled(!this.taskList.isSelectionEmpty() && !((ProgressThread)this.taskList.getSelectedValue()).isCancelled());
    }

    public void refreshDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final ProgressThread current = ProgressThread.getCurrent();
                if (current != null) {
                    final ProgressDisplay display = current.getDisplay();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String message = display.getMessage();
                            if (message == null) {
                                ProgressThreadDialog.this.mainLabel.setText(current.getName());
                            } else {
                                ProgressThreadDialog.this.mainLabel.setText(current.getName() + ": " + message);
                            }
                            ProgressThreadDialog.this.mainProgressBar.setMaximum(display.getTotal());
                            ProgressThreadDialog.this.mainProgressBar.setValue(display.getCompleted());
                        }
                    });
                } else {
                    ProgressThreadDialog.this.mainLabel.setText("-");
                    ProgressThreadDialog.this.mainProgressBar.setValue(0);
                    ProgressThreadDialog.this.mainProgressBar.setEnabled(false);
                }
            }
        });
    }
}

