/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ProgressDisplay;
import com.rapidminer.gui.tools.ProgressThreadDialog;
import com.rapidminer.gui.tools.ProgressThreadStoppedException;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;

public abstract class ProgressThread
implements Runnable {
    private static ProgressThread current = null;
    private static ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "ProgressThread");
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        }
    });
    static final QueueListModel QUEUE_MODEL = new QueueListModel();
    private final ProgressDisplay display;
    private final String name;
    private boolean runInForeground;
    private static final Object LOCK = new Object();
    private boolean cancelled = false;
    private boolean started = false;

    public ProgressThread(String i18nKey) {
        this(i18nKey, false);
    }

    public ProgressThread(String i18nKey, boolean runInForeground) {
        this.name = I18N.getMessage(I18N.getGUIBundle(), "gui.progress." + i18nKey + ".label", new Object[0]);
        this.display = new ProgressDisplay(this.name);
        this.runInForeground = runInForeground;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + (this.cancelled ? " (cancelled)" : "");
    }

    public ProgressListener getProgressListener() {
        return this.display.getListener();
    }

    public ProgressDisplay getDisplay() {
        return this.display;
    }

    public void start() {
        EXECUTOR.execute(this.makeWrapper());
    }

    public void startAndWait() {
        try {
            EXECUTOR.submit(this.makeWrapper()).get();
        }
        catch (InterruptedException e) {
            LogService.getRoot().log(Level.SEVERE, "Cannot execute '" + this.name + "'.", e);
        }
        catch (ExecutionException e) {
            LogService.getRoot().log(Level.SEVERE, "Cannot execute '" + this.name + "'.", e);
        }
    }

    private Runnable makeWrapper() {
        ProgressThread.QUEUE_MODEL.add(this);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    if (ProgressThread.this.cancelled) {
                        LogService.getRoot().info("Task " + ProgressThread.this.getName() + " was cancelled.");
                        return;
                    }
                    ProgressThread.this.started = true;
                }
                try {
                    current = ProgressThread.this;
                    if (ProgressThread.this.runInForeground) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!ProgressThreadDialog.getInstance().isVisible()) {
                                    ProgressThreadDialog.getInstance().setVisible(true);
                                }
                            }
                        });
                    }
                    ProgressThread.this.run();
                }
                catch (ProgressThreadStoppedException e) {
                    LogService.getRoot().fine("Progress thread " + ProgressThread.this.getName() + " aborted (cancelled).");
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Error executing background job '" + ProgressThread.this.name + "': " + e, e);
                    SwingTools.showSimpleErrorMessage("error_executing_background_job", (Throwable)e, ProgressThread.this.name, e);
                }
                finally {
                    ProgressThread.this.getProgressListener().complete();
                    QUEUE_MODEL.remove(ProgressThread.this);
                    current = null;
                }
            }
        };
    }

    public static ProgressThread getCurrent() {
        return current;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = LOCK;
        synchronized (object) {
            this.cancelled = true;
            if (this.started) {
                this.executionCancelled();
                ProgressThread.QUEUE_MODEL.jobCancelled(this);
            } else {
                ProgressThread.QUEUE_MODEL.remove(this);
            }
        }
    }

    protected void executionCancelled() {
    }

    protected void checkCancelled() throws ProgressThreadStoppedException {
        if (this.cancelled) {
            throw new ProgressThreadStoppedException();
        }
    }

    protected static final class QueueListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private List<ProgressThread> queue = new ArrayList<ProgressThread>();

        protected QueueListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return this.queue.get(index);
        }

        @Override
        public int getSize() {
            return this.queue.size();
        }

        private void add(final ProgressThread thread) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueueListModel.this.queue.add(thread);
                    QueueListModel.this.fireIntervalAdded(this, QueueListModel.this.queue.size() - 1, QueueListModel.this.queue.size() - 1);
                }
            });
        }

        private void remove(final ProgressThread thread) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int index = QueueListModel.this.queue.indexOf(thread);
                    QueueListModel.this.queue.remove(index);
                    QueueListModel.this.fireIntervalRemoved(this, index, index);
                }
            });
        }

        private void jobCancelled(ProgressThread pt) {
            int index = this.queue.indexOf(pt);
            this.fireContentsChanged(this, index, index);
        }
    }
}

