/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ProgressMonitor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressDialog
extends JDialog
implements ChangeListener {
    private static final long serialVersionUID = -8792339176006884719L;
    private JLabel statusLabel = new JLabel();
    private JProgressBar progressBar;
    private transient ProgressMonitor monitor;

    public ProgressDialog(Frame owner, String title, ProgressMonitor monitor, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init(monitor);
    }

    public ProgressDialog(Dialog owner, String title, ProgressMonitor monitor, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init(monitor);
    }

    private void init(ProgressMonitor monitor) {
        this.monitor = monitor;
        this.progressBar = new JProgressBar(0, monitor.getTotal());
        if (monitor.isIndeterminate()) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setValue(monitor.getCurrent());
        }
        this.statusLabel.setText(monitor.getStatus());
        JPanel contents = (JPanel)this.getContentPane();
        contents.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        contents.add((Component)this.statusLabel, "North");
        contents.add(this.progressBar);
        this.setDefaultCloseOperation(2);
        monitor.addChangeListener(this);
    }

    @Override
    public void stateChanged(final ChangeEvent ce) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.stateChanged(ce);
                }
            });
            return;
        }
        this.statusLabel.setText(this.monitor.getStatus());
        if (!this.monitor.isIndeterminate()) {
            this.progressBar.setValue(this.monitor.getCurrent());
        }
        if (this.monitor.getCurrent() >= this.monitor.getTotal()) {
            this.dispose();
        }
    }
}

