/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.actions.ExportViewAction;
import com.rapidminer.gui.actions.PrintAction;
import com.rapidminer.gui.actions.PrintPreviewAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.components.DropDownButton;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JMenu;

public class PrintingTools {
    private static final PrinterJob PRINTER_JOB = PrinterJob.getPrinterJob();
    private static PageFormat pageFormat = PrintingTools.getPrinterJob().defaultPage();
    private static PrintRequestAttributeSet printSettings = new HashPrintRequestAttributeSet();

    public static PrinterJob getPrinterJob() {
        return PRINTER_JOB;
    }

    public static void setPageFormat(PageFormat pageFormat) {
        PrintingTools.pageFormat = pageFormat;
    }

    public static PageFormat getPageFormat() {
        return pageFormat;
    }

    public static void editPrintSettings() {
        PrintingTools.getPrinterJob().pageDialog(printSettings);
    }

    public static PrintRequestAttributeSet getPrintSettings() {
        return printSettings;
    }

    public static void print(Printable printable) {
        PrintingTools.getPrinterJob().setPrintable(printable);
        if (PrintingTools.getPrinterJob().printDialog()) {
            try {
                PrintingTools.getPrinterJob().print(printSettings);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    public static void print(Printable printable, PrintRequestAttributeSet printSettings) {
        PrintingTools.getPrinterJob().setPrintable(printable);
        if (PrintingTools.getPrinterJob().printDialog(printSettings)) {
            try {
                PrintingTools.getPrinterJob().print(printSettings);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    public static DropDownButton makeExportPrintDropDownButton(Component component, String componentName) {
        return DropDownButton.makeDropDownButton(new ResourceActionAdapter(true, "export_and_print"), new PrintAction(component, componentName), new PrintPreviewAction(component, componentName), new ExportViewAction(component, componentName));
    }

    public static JMenu makeExportPrintMenu(Component component, String componentName) {
        JMenu menu = new JMenu(new ResourceActionAdapter(true, "export_and_print"));
        menu.add(new PrintAction(component, componentName));
        menu.add(new PrintPreviewAction(component, componentName));
        menu.add(new ExportViewAction(component, componentName));
        return menu;
    }
}

