/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.io.Base64;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.XMLException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PasswordDialog
extends ButtonDialog {
    private static final String CACHE_FILE_NAME = "secrets.xml";
    private static Map<String, PasswordAuthentication> CACHE = new HashMap<String, PasswordAuthentication>();
    private static final long serialVersionUID = 1L;
    private JTextField usernameField = new JTextField(20);
    private JPasswordField passwordField = new JPasswordField(20);
    private JCheckBox rememberBox = new JCheckBox(new ResourceActionAdapter("authentication.remember", new Object[0]));

    private PasswordDialog(PasswordAuthentication preset, String url) {
        super("authentication", url);
        this.setModal(true);
        if (preset != null) {
            this.usernameField.setText(preset.getUserName());
        }
        if (preset != null) {
            this.passwordField.setText(new String(preset.getPassword()));
            this.rememberBox.setSelected(true);
        }
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(4, 4, 4, 4);
        ResourceLabel label = new ResourceLabel("authentication.username", url);
        label.setLabelFor(this.usernameField);
        c.gridwidth = -1;
        main.add((Component)label, c);
        c.gridwidth = 0;
        main.add((Component)this.usernameField, c);
        label = new ResourceLabel("authentication.password", url);
        label.setLabelFor(this.passwordField);
        c.gridwidth = -1;
        main.add((Component)label, c);
        c.gridwidth = 0;
        main.add((Component)this.passwordField, c);
        main.add((Component)this.rememberBox, c);
        this.layoutDefault((JComponent)main, this.makeCancelButton(), this.makeOkButton());
    }

    public PasswordAuthentication makeAuthentication() {
        return new PasswordAuthentication(this.usernameField.getText(), this.passwordField.getPassword());
    }

    public static PasswordAuthentication getPasswordAuthentication(String forUrl, boolean forceRefresh) {
        return PasswordDialog.getPasswordAuthentication(forUrl, forceRefresh, false);
    }

    public static PasswordAuthentication getPasswordAuthentication(String forUrl, boolean forceRefresh, boolean hideDialogIfPasswordKnown) {
        PasswordAuthentication authentication = CACHE.get(forUrl);
        if (hideDialogIfPasswordKnown && !forceRefresh && authentication != null && authentication.getPassword() != null) {
            LogService.getRoot().config("Reusing cached password for " + forUrl + ".");
            return authentication;
        }
        if (forceRefresh && authentication != null) {
            authentication = new PasswordAuthentication(authentication.getUserName(), null);
            CACHE.put(forUrl, authentication);
        }
        PasswordDialog pd = new PasswordDialog(authentication, forUrl);
        pd.setVisible(true);
        if (pd.wasConfirmed()) {
            PasswordAuthentication result = pd.makeAuthentication();
            if (pd.rememberBox.isSelected()) {
                CACHE.put(forUrl, result);
            } else {
                CACHE.remove(forUrl);
            }
            PasswordDialog.saveCache();
            return result;
        }
        return null;
    }

    private static void saveCache() {
        Document doc;
        LogService.getRoot().config("Saving secrets file.");
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to create XML document: " + e, e);
            return;
        }
        Element root = doc.createElement(CACHE_FILE_NAME);
        doc.appendChild(root);
        for (Map.Entry<String, PasswordAuthentication> entry : CACHE.entrySet()) {
            Element entryElem = doc.createElement("secret");
            root.appendChild(entryElem);
            XMLTools.setTagContents(entryElem, "url", entry.getKey());
            XMLTools.setTagContents(entryElem, "user", entry.getValue().getUserName());
            XMLTools.setTagContents(entryElem, "password", Base64.encodeBytes(new String(entry.getValue().getPassword()).getBytes()));
        }
        File file = ParameterService.getUserConfigFile(CACHE_FILE_NAME);
        try {
            XMLTools.stream(doc, file, null);
        }
        catch (XMLException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to save secrets file: " + e, e);
        }
    }

    private static void readCache() {
        Document doc;
        File userConfigFile = ParameterService.getUserConfigFile(CACHE_FILE_NAME);
        if (!userConfigFile.exists()) {
            return;
        }
        LogService.getRoot().config("Reading secrets file.");
        try {
            doc = XMLTools.parse(userConfigFile);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to read secrets file: " + e, e);
            return;
        }
        NodeList secretElems = doc.getDocumentElement().getElementsByTagName("secret");
        for (int i = 0; i < secretElems.getLength(); ++i) {
            String password;
            Element secretElem = (Element)secretElems.item(i);
            String url = XMLTools.getTagContents(secretElem, "url");
            String user = XMLTools.getTagContents(secretElem, "user");
            try {
                password = new String(Base64.decode(XMLTools.getTagContents(secretElem, "password")));
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Failed to read entry in secrets file: " + e, e);
                continue;
            }
            CACHE.put(url, new PasswordAuthentication(user, password.toCharArray()));
        }
    }

    static {
        PasswordDialog.readCache();
    }
}

