/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.ArrowButton;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ParentButtonModel;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.components.DropDownButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ParentButtonPanel<T>
extends ExtendedJToolBar {
    private static final int HISTORY_SIZE = 20;
    private static final long serialVersionUID = 7115627292465260984L;
    private LinkedList<T> backward = new LinkedList();
    private LinkedList<T> forward = new LinkedList();
    private ParentButtonModel<T> model;
    private T currentNode;
    private T selectedNode;
    private boolean selectionByHistory = false;
    private DropDownButton backwardButton = new DropDownButton(new ResourceAction(true, "select_backward", new Object[0]){
        private static final long serialVersionUID = 3096873810683015968L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ParentButtonPanel.this.backward.size() > 1) {
                ParentButtonPanel.this.forward.addFirst(ParentButtonPanel.this.backward.removeFirst());
                ParentButtonPanel.this.selectedNode = ParentButtonPanel.this.backward.getFirst();
                ParentButtonPanel.this.selectionByHistory = true;
                ParentButtonPanel.this.fireAction();
            }
        }
    }){
        private static final long serialVersionUID = -770314831566061205L;

        @Override
        protected JPopupMenu getPopupMenu() {
            return ParentButtonPanel.this.createBackwardMenu();
        }
    };
    private DropDownButton forwardButton = new DropDownButton(new ResourceAction(true, "select_forward", new Object[0]){
        private static final long serialVersionUID = -5189987068889279439L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ParentButtonPanel.this.forward.size() > 0) {
                ParentButtonPanel.this.backward.addFirst(ParentButtonPanel.this.forward.removeFirst());
                ParentButtonPanel.this.selectedNode = ParentButtonPanel.this.backward.getFirst();
                ParentButtonPanel.this.selectionByHistory = true;
                ParentButtonPanel.this.fireAction();
            }
        }
    }){
        private static final long serialVersionUID = -770314831566061205L;

        @Override
        protected JPopupMenu getPopupMenu() {
            return ParentButtonPanel.this.createForwardMenu();
        }
    };
    private JButton upButton = new JButton(new ResourceAction(true, "select_parent", new Object[0]){
        private static final long serialVersionUID = -5411675828764033039L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ParentButtonPanel.this.selectedNode = ParentButtonPanel.this.model.getParent(ParentButtonPanel.this.currentNode);
            ParentButtonPanel.this.fireAction();
        }
    });
    private final MouseListener borderListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!(e.getComponent() instanceof JToolBar.Separator)) {
                ((AbstractButton)e.getComponent()).setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!(e.getComponent() instanceof JToolBar.Separator)) {
                ((AbstractButton)e.getComponent()).setBorderPainted(false);
            }
        }
    };
    private EventListenerList listeners = new EventListenerList();
    private int eventId = 0;

    public ParentButtonPanel() {
        this((ParentButtonModel<T>)null);
    }

    public ParentButtonPanel(ParentButtonModel<T> model) {
        this.setModel(model);
        this.setOpaque(false);
    }

    @Override
    public Component add(Component c) {
        Component result = super.add(c);
        c.addMouseListener(this.borderListener);
        return result;
    }

    public void setSelectedNode(T node) {
        this.currentNode = node;
        this.upButton.setEnabled(this.model.getParent(this.currentNode) != null);
        this.backwardButton.setEnabled(this.backward.size() > 1);
        this.forwardButton.setEnabled(this.forward.size() > 0);
        this.setup();
    }

    public void setModel(ParentButtonModel<T> model) {
        this.model = model;
        this.setup();
    }

    private void setup() {
        this.removeAll();
        this.backwardButton.addToToolBar(this);
        this.forwardButton.addToToolBar(this);
        this.add(this.upButton);
        this.addSeparator();
        if (this.model != null) {
            LinkedList<T> nodes = new LinkedList<T>();
            T node = this.currentNode;
            while (node != null) {
                nodes.addFirst(node);
                node = this.model.getParent(node);
            }
            for (Object n : nodes) {
                this.add(this.makeButton(n));
                this.add(this.makeDropdownButton(n));
            }
        }
        this.revalidate();
        this.repaint();
    }

    private JPopupMenu createBackwardMenu() {
        JPopupMenu menu = new JPopupMenu("History");
        boolean first = true;
        for (final Object node : this.backward) {
            if (first) {
                first = false;
                continue;
            }
            menu.add(new AbstractAction(this.model.toString(node)){
                private static final long serialVersionUID = 1L;
                {
                    super(x0);
                    this.putValue("SmallIcon", ParentButtonPanel.this.model.getIcon(node));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object nextNode;
                    ParentButtonPanel.this.selectedNode = node;
                    Iterator iterator = ParentButtonPanel.this.backward.iterator();
                    while (iterator.hasNext() && (nextNode = iterator.next()) != node) {
                        iterator.remove();
                        ParentButtonPanel.this.forward.addFirst(nextNode);
                    }
                    ParentButtonPanel.this.selectionByHistory = true;
                    ParentButtonPanel.this.fireAction();
                }
            });
        }
        return menu;
    }

    private JPopupMenu createForwardMenu() {
        JPopupMenu menu = new JPopupMenu("History");
        for (final Object node : this.forward) {
            menu.add(new AbstractAction(this.model.toString(node)){
                private static final long serialVersionUID = 1L;
                {
                    super(x0);
                    this.putValue("SmallIcon", ParentButtonPanel.this.model.getIcon(node));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParentButtonPanel.this.selectedNode = node;
                    Iterator iterator = ParentButtonPanel.this.forward.iterator();
                    while (iterator.hasNext()) {
                        Object nextNode = iterator.next();
                        iterator.remove();
                        ParentButtonPanel.this.backward.addFirst(nextNode);
                        if (nextNode != node) continue;
                        break;
                    }
                    ParentButtonPanel.this.selectionByHistory = true;
                    ParentButtonPanel.this.fireAction();
                }
            });
        }
        return menu;
    }

    private JButton makeButton(final T node) {
        JButton button = new JButton(this.model.toString(node), this.model.getIcon(node));
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParentButtonPanel.this.selectedNode = node;
                ParentButtonPanel.this.fireAction();
            }
        });
        return button;
    }

    private JButton makeDropdownButton(final T node) {
        final ArrowButton button = new ArrowButton(3);
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = ParentButtonPanel.this.makeMenu(node);
                button.setDirection(5);
                menu.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        button.setDirection(3);
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }
                });
                menu.show(button, 0, button.getHeight());
            }
        });
        return button;
    }

    private JPopupMenu makeMenu(T node) {
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < this.model.getNumberOfChildren(node); ++i) {
            final T child = this.model.getChild(node, i);
            menu.add(new AbstractAction(this.model.toString(child)){
                private static final long serialVersionUID = 7232177147279985209L;
                {
                    super(x0);
                    this.putValue("SmallIcon", ParentButtonPanel.this.model.getIcon(child));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParentButtonPanel.this.selectedNode = child;
                    ParentButtonPanel.this.fireAction();
                }
            });
        }
        return menu;
    }

    public T getSelectedNode() {
        return this.selectedNode;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(ActionListener.class, l);
    }

    public void clearHistory() {
        this.backward.clear();
        this.forward.clear();
    }

    public void addToHistory(T node) {
        if (node == null) {
            return;
        }
        if (this.backward.size() > 0) {
            if (this.backward.getFirst() != node) {
                this.backward.remove(node);
                this.backward.addFirst(node);
                if (!this.selectionByHistory) {
                    this.forward.clear();
                }
            }
        } else {
            this.backward.remove(node);
            this.backward.addFirst(node);
            if (!this.selectionByHistory) {
                this.forward.clear();
            }
        }
        while (this.backward.size() > 20) {
            this.backward.removeLast();
        }
        this.selectionByHistory = false;
        this.backwardButton.setEnabled(this.backward.size() > 1);
        this.forwardButton.setEnabled(this.forward.size() > 0);
    }

    private void fireAction() {
        ActionEvent e = new ActionEvent(this, this.eventId++, "select");
        for (ActionListener l : (ActionListener[])this.listeners.getListeners(ActionListener.class)) {
            l.actionPerformed(e);
        }
        this.upButton.setEnabled(this.model.getParent(this.currentNode) != null);
        this.backwardButton.setEnabled(this.backward.size() > 1);
        this.forwardButton.setEnabled(this.forward.size() > 0);
    }
}

