/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.dnd.OperatorTransferHandler;
import com.rapidminer.gui.operatortree.actions.InfoOperatorAction;
import com.rapidminer.gui.tools.OperatorListCellRenderer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class OperatorList
extends JList
implements MouseListener {
    private static final long serialVersionUID = -2719941529572427942L;
    private final transient Action INFO_OPERATOR_ACTION = new InfoOperatorAction(){
        private static final long serialVersionUID = 1L;

        @Override
        protected Operator getOperator() {
            return OperatorList.this.selectedOperator;
        }
    };
    private final OperatorListCellRenderer operatorDialogCellRenderer;
    private transient Operator selectedOperator;

    public OperatorList() {
        this(false, true);
    }

    public OperatorList(boolean horizontalWrap, boolean coloredCellBackgrounds) {
        this.operatorDialogCellRenderer = new OperatorListCellRenderer(coloredCellBackgrounds);
        if (horizontalWrap) {
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(-1);
        }
        this.setCellRenderer(this.operatorDialogCellRenderer);
        this.setSelectionMode(0);
        this.addMouseListener(this);
        this.setDragEnabled(true);
        this.setTransferHandler(new OperatorTransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<Operator> getDraggedOperators() {
                return Collections.singletonList(OperatorList.this.getSelectedOperator());
            }
        });
    }

    public void setOperatorDescriptions(Vector<OperatorDescription> descriptions) {
        this.setListData(descriptions);
    }

    private Operator getSelectedOperator() {
        Point clickOrigin = this.getMousePosition();
        if (clickOrigin == null) {
            return null;
        }
        int selectedIndex = this.locationToIndex(clickOrigin);
        if (selectedIndex != -1) {
            this.setSelectedIndex(selectedIndex);
        }
        OperatorDescription selectedListElement = (OperatorDescription)this.getSelectedValue();
        Operator selectedOperator = null;
        if (selectedListElement != null) {
            try {
                selectedOperator = selectedListElement.createOperatorInstance();
            }
            catch (OperatorCreationException ocE) {
                ocE.printStackTrace();
            }
        }
        return selectedOperator;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selectedOperator = this.getSelectedOperator();
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createOperatorPopupMenu().show(this, e.getX(), e.getY());
        }
    }

    private JPopupMenu createOperatorPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.INFO_OPERATOR_ACTION);
        return menu;
    }
}

