/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.SearchDialog;
import com.rapidminer.gui.dialog.SearchableJTextComponent;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.LoggingLevelMenu;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.actions.ClearMessageAction;
import com.rapidminer.gui.tools.actions.LoggingSearchAction;
import com.rapidminer.gui.tools.actions.SaveLogFileAction;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LoggingViewer
extends JPanel
implements MouseListener,
Dockable {
    private static final long serialVersionUID = 551259537624386372L;
    public static final Level[] SELECTABLE_LEVELS = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    public static final int DEFAULT_LEVEL_INDEX = 4;
    public static final String[] SELECTABLE_LEVEL_NAMES = new String[SELECTABLE_LEVELS.length];
    public final transient Action CLEAR_MESSAGE_VIEWER_ACTION = new ClearMessageAction(this);
    public final transient Action SAVE_LOGFILE_ACTION = new SaveLogFileAction(this);
    public final transient Action SEARCH_ACTION = new LoggingSearchAction(this);
    public final transient JMenu LEVEL_MENU = new LoggingLevelMenu(this);
    private final transient SimpleAttributeSet attributeSet = new SimpleAttributeSet();
    private final transient LinkedList<Integer> lineLengths = new LinkedList();
    private final JTextPane textArea;
    private static final Color COLOR_DEFAULT;
    private static final Color COLOR_WARNING;
    private static final Color COLOR_ERROR;
    private static final Color COLOR_INFO;
    private final Formatter formatter = new Formatter(){

        @Override
        public String format(LogRecord record) {
            StringBuilder b = new StringBuilder();
            b.append(DateFormat.getDateTimeInstance().format(new Date(record.getMillis())));
            b.append(" ");
            b.append(record.getLevel().getLocalizedName());
            b.append(": ");
            b.append(record.getMessage());
            b.append("\n");
            return b.toString();
        }
    };
    private int maxRows;
    private final Handler handler = new Handler(){

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(final LogRecord record) {
            if (this.isLoggable(record)) {
                if (SwingUtilities.isEventDispatchThread()) {
                    LoggingViewer.this.append(record);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LoggingViewer.this.append(record);
                        }
                    });
                }
            }
        }
    };
    public static final String LOG_VIEWER_DOCK_KEY = "log_viewer";
    private final DockKey DOCK_KEY = new ResourceDockKey("log_viewer");

    public LoggingViewer() {
        this(new JTextPane());
    }

    private LoggingViewer(JTextPane textArea) {
        super(new BorderLayout());
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        Level level = LoggingViewer.getSpecifiedLogLevelIndex();
        this.handler.setLevel(level);
        LogService.getRoot().setLevel(level);
        this.maxRows = 1000;
        try {
            String maxRowsString = System.getProperty("rapidminer.gui.messageviewer.rowlimit");
            if (maxRowsString != null) {
                this.maxRows = Integer.parseInt(maxRowsString);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Bad integer format for property '', using default number of maximum rows for logging (1000).", 5);
        }
        this.textArea = textArea;
        this.textArea.setToolTipText("Displays logging messages according to the current log verbosity (parameter of root operator).");
        this.textArea.setEditable(false);
        this.textArea.addMouseListener(this);
        this.textArea.setFont(this.textArea.getFont().deriveFont(0));
        LogService.getRoot().addHandler(this.handler);
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        toolBar.add(this.SAVE_LOGFILE_ACTION);
        toolBar.add(this.CLEAR_MESSAGE_VIEWER_ACTION);
        toolBar.add(this.SEARCH_ACTION);
        this.add((Component)toolBar, "North");
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(textArea);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    private static Level getSpecifiedLogLevelIndex() {
        String value = System.getProperty("rapidminer.gui.log_level");
        if (value == null) {
            return Level.CONFIG;
        }
        for (int i = 0; i < SELECTABLE_LEVEL_NAMES.length; ++i) {
            if (!SELECTABLE_LEVEL_NAMES[i].equals(value)) continue;
            return SELECTABLE_LEVELS[i];
        }
        return Level.CONFIG;
    }

    public void setLevel(Level level) {
        LogService.getRoot().setLevel(level);
        this.handler.setLevel(level);
        ParameterService.writePropertyIntoMainUserConfigFile("rapidminer.gui.log_level", level.getName());
    }

    protected Object readResolve() {
        return this;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu().show(this.textArea, e.getX(), e.getY());
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.CLEAR_MESSAGE_VIEWER_ACTION);
        menu.add(this.SAVE_LOGFILE_ACTION);
        menu.add(this.SEARCH_ACTION);
        menu.add(this.LEVEL_MENU);
        return menu;
    }

    private synchronized void append(LogRecord record) {
        StyledDocument doc = this.textArea.getStyledDocument();
        String formatted = this.formatter.format(record);
        if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
            StyleConstants.setForeground(this.attributeSet, COLOR_ERROR);
            StyleConstants.setBold(this.attributeSet, true);
        } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            StyleConstants.setForeground(this.attributeSet, COLOR_WARNING);
            StyleConstants.setBold(this.attributeSet, true);
        } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
            StyleConstants.setForeground(this.attributeSet, COLOR_INFO);
            StyleConstants.setBold(this.attributeSet, false);
        } else {
            StyleConstants.setForeground(this.attributeSet, COLOR_DEFAULT);
            StyleConstants.setBold(this.attributeSet, false);
        }
        try {
            doc.insertString(doc.getLength(), formatted, this.attributeSet);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (this.maxRows >= 0) {
            int removeLength = 0;
            while (this.lineLengths.size() > this.maxRows) {
                removeLength += this.lineLengths.removeFirst().intValue();
            }
            try {
                doc.remove(0, removeLength);
            }
            catch (BadLocationException e) {
                SwingTools.showSimpleErrorMessage("error_during_logging", (Throwable)e, new Object[0]);
            }
        }
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public String getLogMessage() {
        return this.textArea.getText();
    }

    public void clear() {
        this.textArea.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLog() {
        File file = new File("." + File.separator);
        String logFile = null;
        try {
            logFile = RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getParameterAsString("logfile");
        }
        catch (UndefinedParameterError ex) {
            // empty catch block
        }
        if (logFile != null) {
            file = RapidMinerGUI.getMainFrame().getProcess().resolveFileName(logFile);
        }
        if ((file = SwingTools.chooseFile(RapidMinerGUI.getMainFrame(), file, false, "log", "log file")) != null) {
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(file));
                out.println(this.textArea.getText());
            }
            catch (IOException ex) {
                SwingTools.showSimpleErrorMessage("cannot_write_log_file", (Throwable)ex, new Object[0]);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void performSearch() {
        new SearchDialog(this.textArea, new SearchableJTextComponent(this.textArea)).setVisible(true);
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }

    static {
        for (int i = 0; i < SELECTABLE_LEVELS.length; ++i) {
            LoggingViewer.SELECTABLE_LEVEL_NAMES[i] = SELECTABLE_LEVELS[i].getName();
        }
        String colorStr = System.getProperty("rapidminer.gui.messageviewer.highlight.logservice");
        COLOR_DEFAULT = colorStr != null ? ParameterTypeColor.string2Color(colorStr) : Color.BLACK;
        colorStr = System.getProperty("rapidminer.gui.messageviewer.highlight.notes");
        COLOR_INFO = colorStr != null ? ParameterTypeColor.string2Color(colorStr) : Color.BLACK;
        colorStr = System.getProperty("rapidminer.gui.messageviewer.highlight.warnings");
        COLOR_WARNING = colorStr != null ? ParameterTypeColor.string2Color(colorStr) : Color.BLACK;
        colorStr = System.getProperty("rapidminer.gui.messageviewer.highlight.errors");
        COLOR_ERROR = colorStr != null ? ParameterTypeColor.string2Color(colorStr) : Color.BLACK;
    }
}

