/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LeanFormatter
extends Formatter {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        StringBuilder b = new StringBuilder();
        b.append(this.dateFormat.format(new Date(record.getMillis())));
        b.append(" ");
        b.append(record.getLevel().getLocalizedName());
        b.append(": ");
        b.append(record.getMessage());
        String className = record.getSourceClassName();
        if (className != null) {
            int dot = className.lastIndexOf(46);
            if (dot != -1) {
                className = className.substring(dot + 1);
            }
            b.append(" (").append(className).append(".").append(record.getSourceMethodName()).append("())");
        }
        b.append("\n");
        this.append(record.getThrown(), b);
        return b.toString();
    }

    private void append(Throwable t, StringBuilder b) {
        if (t != null) {
            b.append("  ").append(t.toString()).append("\n");
            for (StackTraceElement elem : t.getStackTrace()) {
                b.append("      " + elem.toString()).append("\n");
            }
            if (t.getCause() != null) {
                b.append("Caused by:\n");
                this.append(t.getCause(), b);
            }
        }
    }
}

