/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.TextPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

public class ImageTextPanel
extends TextPanel {
    private static final long serialVersionUID = -5728947680003081065L;
    public static final int TEXT_START_Y = -1;
    private transient Image image = null;
    private boolean rescaleImage = false;
    private int imageX = 0;
    private int imageY = -1;

    public ImageTextPanel(Image image, String title, String[] textLines, int xAlignment, int yAlignment) {
        this(image, title, textLines, xAlignment, yAlignment, false);
    }

    public ImageTextPanel(Image image, String title, String[] textLines, int xAlignment, int yAlignment, boolean rescaleImage) {
        this(image, title, textLines, xAlignment, yAlignment, rescaleImage, 0, -1);
    }

    public ImageTextPanel(Image image, String title, String[] textLines, int xAlignment, int yAlignment, boolean rescaleImage, int imageX, int imageY) {
        super(title, textLines, xAlignment, yAlignment);
        this.image = image;
        this.rescaleImage = rescaleImage;
        this.imageX = imageX;
        this.imageY = imageY;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (this.image != null) {
            int actualImageY = this.imageY;
            if (this.imageY == -1) {
                actualImageY = this.getTextStartY();
            }
            if (this.rescaleImage) {
                g.drawImage(this.image, this.imageX, actualImageY, this.getWidth() - this.imageX, this.getHeight() - actualImageY, this);
            } else {
                g.drawImage(this.image, this.imageX, actualImageY, this);
            }
        } else {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(graphics);
    }
}

