/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.FilterListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.AbstractListModel;

public class FilterableListModel
extends AbstractListModel
implements FilterListener {
    private static final long serialVersionUID = 552254394780900171L;
    private LinkedList<Object> list;
    private LinkedList<Object> filteredList;
    private Comparator<Object> comparator;
    private String filterValue;
    private LinkedList<FilterCondition> conditions = new LinkedList();

    public FilterableListModel() {
        this.list = new LinkedList();
        this.filteredList = new LinkedList();
        this.comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    @Override
    public void valueChanged(String value) {
        this.filteredList.clear();
        if (value == null || value.trim().length() == 0 || value.equals("")) {
            for (Object e : this.list) {
                if (this.filteredByCondition(e)) continue;
                this.filteredList.add(e);
            }
        } else {
            for (Object e : this.list) {
                if (!e.toString().contains(value) || this.filteredByCondition(e)) continue;
                this.filteredList.add(e);
            }
        }
        this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
        this.filterValue = value;
    }

    public void addElement(Object o) {
        this.list.add(o);
        Collections.sort(this.list, this.comparator);
        if (this.filterValue == null) {
            this.filteredList.add(o);
        } else if (o.toString().contains(this.filterValue)) {
            this.filteredList.add(o);
        }
        Collections.sort(this.filteredList, this.comparator);
        this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
    }

    public void removeElement(Object o) {
        this.list.remove(o);
        Collections.sort(this.list, this.comparator);
        if (this.filteredList.contains(o)) {
            this.filteredList.remove(o);
        }
        this.fireContentsChanged(this, this.filteredList.size() - 2, this.filteredList.size() - 1);
    }

    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public void removeElementAt(int index) {
        this.list.remove(this.filteredList.remove(index));
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public Object getElementAt(int index) {
        return this.filteredList.get(index);
    }

    public int indexOf(Object o) {
        return this.filteredList.indexOf(o);
    }

    @Override
    public int getSize() {
        return this.filteredList.size();
    }

    private boolean filteredByCondition(Object o) {
        for (FilterCondition c : this.conditions) {
            if (!c.matches(o)) continue;
            return true;
        }
        return false;
    }

    public void addCondition(FilterCondition c) {
        this.conditions.add(c);
        this.filteredList.clear();
        if (this.filterValue == null || this.filterValue.trim().length() == 0 || this.filterValue.equals("")) {
            for (Object e : this.list) {
                if (this.filteredByCondition(e)) continue;
                this.filteredList.add(e);
            }
        } else {
            for (Object e : this.list) {
                if (!e.toString().contains(this.filterValue) || this.filteredByCondition(e)) continue;
                this.filteredList.add(e);
            }
        }
        this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
    }

    public void removeCondition(FilterCondition c) {
        this.conditions.remove(c);
        this.filteredList.clear();
        if (this.filterValue == null || this.filterValue.trim().length() == 0 || this.filterValue.equals("")) {
            for (Object e : this.list) {
                if (this.filteredByCondition(e)) continue;
                this.filteredList.add(e);
            }
        } else {
            for (Object e : this.list) {
                if (!e.toString().contains(this.filterValue) || this.filteredByCondition(e)) continue;
                this.filteredList.add(e);
            }
        }
        this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
    }

    public static abstract class FilterCondition {
        public abstract boolean matches(Object var1);
    }
}

