/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.rapidminer.gui.tools.ExtendedJComboBox;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class FilterableJComboBox
extends ExtendedJComboBox {
    private static final long serialVersionUID = -4910048606664095221L;
    private transient AutoCompleteSupport<String> autoCompl;

    public FilterableJComboBox(String[] values) {
        super(values);
        Vector<String> valueVector = new Vector<String>();
        valueVector.addAll(Arrays.asList(values));
        this.refreshAutoCompletionSupport(valueVector);
    }

    public FilterableJComboBox(ComboBoxModel model) {
        super(model);
        Vector<String> values = new Vector<String>();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            values.add((String)model.getElementAt(i));
        }
        this.refreshAutoCompletionSupport(values);
    }

    public FilterableJComboBox(Vector<String> values) {
        super(values.toArray(new String[values.size()]));
        this.refreshAutoCompletionSupport(values);
    }

    private void initAutoCompletition(Vector<String> valueVector) {
        this.autoCompl = AutoCompleteSupport.install((JComboBox)this, (EventList)GlazedLists.eventList(valueVector));
        this.autoCompl.setStrict(false);
        this.autoCompl.setCorrectsCase(false);
        this.autoCompl.setFilterMode(1);
        this.autoCompl.setSelectsTextOnFocusGain(true);
        this.autoCompl.setTextMatchingStrategy(TextMatcherEditor.NORMALIZED_STRATEGY);
    }

    public void refreshAutoCompletionSupport(Vector<String> values) {
        if (this.autoCompl != null) {
            this.autoCompl.uninstall();
            this.autoCompl = null;
        }
        this.initAutoCompletition(values);
    }

    public AutoCompleteSupport<String> getAutoCompleteSupport() {
        return this.autoCompl;
    }
}

